#include "CvGameCoreDLL.h"
#include"CvEnums.h"

#include "CvGameCoreDLLUnDefNew.h"
# include <boost/python/enum.hpp>
#include "CvGameCoreDLLDefNew.h"

// Dale - AB: Bombing PLEASE NOTE!
//		There are new interfaces defined in this file.
//		Browse to: python::enum_<InterfaceModeTypes>("InterfaceModeTypes")
//		At the bottom of that list you will see the new interfaces
//		for bombing.  Do not forget to add this, or your
//		units will rebase instead.  :)
//		There are also new missions defined in this file.
//		Browse to: 	python::enum_<MissionTypes>("MissionTypes")
//		At the bottom of that list the new missions are listed.
//
// Python interface for free enums
//

void CyEnumsPythonInterface()
{
	OutputDebugString("Python Extension Module - CyEnumsPythonInterface\n");

	python::enum_<GameStateTypes>("GameStateTypes")
		.value("GAMESTATE_ON", GAMESTATE_ON)
		.value("GAMESTATE_OVER", GAMESTATE_OVER)
		.value("GAMESTATE_EXTENDED", GAMESTATE_EXTENDED)
		;

	python::enum_<PopupStates>("PopupStates")
		.value("POPUPSTATE_IMMEDIATE", POPUPSTATE_IMMEDIATE)
		.value("POPUPSTATE_QUEUED", POPUPSTATE_QUEUED)
		.value("POPUPSTATE_MINIMIZED", POPUPSTATE_MINIMIZED)
		;

	python::enum_<CameraLookAtTypes>("CameraLookAtTypes")
		.value("CAMERALOOKAT_NORMAL", CAMERALOOKAT_NORMAL)
		.value("CAMERALOOKAT_CITY_ZOOM_IN", CAMERALOOKAT_CITY_ZOOM_IN)
		.value("CAMERALOOKAT_BATTLE", CAMERALOOKAT_BATTLE)
		.value("CAMERALOOKAT_BATTLE_ZOOM_IN", CAMERALOOKAT_BATTLE_ZOOM_IN)
		.value("CAMERALOOKAT_IMMEDIATE", CAMERALOOKAT_IMMEDIATE)
		;

	python::enum_<CameraMovementSpeeds>("CameraMovementSpeeds")
		.value("CAMERAMOVEMENTSPEED_NORMAL", CAMERAMOVEMENTSPEED_NORMAL)
		.value("CAMERAMOVEMENTSPEED_SLOW", CAMERAMOVEMENTSPEED_SLOW)
		.value("CAMERAMOVEMENTSPEED_FAST", CAMERAMOVEMENTSPEED_FAST)
		;

	python::enum_<ZoomLevelTypes>("ZoomLevelTypes")
		.value("ZOOM_UNKNOWN", ZOOM_UNKNOWN)
		.value("ZOOM_GLOBEVIEW", ZOOM_GLOBEVIEW)
		.value("ZOOM_NORMAL", ZOOM_NORMAL)
		.value("ZOOM_DETAIL", ZOOM_DETAIL)
		;

	python::enum_<DirectionTypes>("DirectionTypes")
		.value("NO_DIRECTION", NO_DIRECTION)
		.value("DIRECTION_NORTH", DIRECTION_NORTH)
		.value("DIRECTION_NORTHEAST", DIRECTION_NORTHEAST)
		.value("DIRECTION_EAST", DIRECTION_EAST)
		.value("DIRECTION_SOUTHEAST", DIRECTION_SOUTHEAST)
		.value("DIRECTION_SOUTH", DIRECTION_SOUTH)
		.value("DIRECTION_SOUTHWEST", DIRECTION_SOUTHWEST)
		.value("DIRECTION_WEST", DIRECTION_WEST)
		.value("DIRECTION_NORTHWEST", DIRECTION_NORTHWEST)
		.value("NUM_DIRECTION_TYPES", NUM_DIRECTION_TYPES)
		;

	python::enum_<CardinalDirectionTypes>("CardinalDirectionTypes")
		.value("NO_CARDINALDIRECTION", NO_CARDINALDIRECTION)
		.value("CARDINALDIRECTION_NORTH", CARDINALDIRECTION_NORTH)
		.value("CARDINALDIRECTION_EAST", CARDINALDIRECTION_EAST)
		.value("CARDINALDIRECTION_SOUTH", CARDINALDIRECTION_SOUTH)
		.value("CARDINALDIRECTION_WEST", CARDINALDIRECTION_WEST)
		.value("NUM_CARDINALDIRECTION_TYPES", NUM_CARDINALDIRECTION_TYPES)
		;

	python::enum_<ColorTypes>("ColorTypes")
		.value("NO_COLOR", NO_COLOR)
		;

	python::enum_<PlayerColorTypes>("PlayerColorTypes")
		.value("NO_PLAYERCOLOR", NO_PLAYERCOLOR)
		;

	python::enum_<PlotStyles>("PlotStyles")
		.value("PLOT_STYLE_NONE", PLOT_STYLE_NONE)
		.value("PLOT_STYLE_NUMPAD_1", PLOT_STYLE_NUMPAD_1)
		.value("PLOT_STYLE_NUMPAD_2", PLOT_STYLE_NUMPAD_2)
		.value("PLOT_STYLE_NUMPAD_3", PLOT_STYLE_NUMPAD_3)
		.value("PLOT_STYLE_NUMPAD_4", PLOT_STYLE_NUMPAD_4)
		.value("PLOT_STYLE_NUMPAD_6", PLOT_STYLE_NUMPAD_6)
		.value("PLOT_STYLE_NUMPAD_7", PLOT_STYLE_NUMPAD_7)
		.value("PLOT_STYLE_NUMPAD_8", PLOT_STYLE_NUMPAD_8)
		.value("PLOT_STYLE_NUMPAD_9", PLOT_STYLE_NUMPAD_9)
		.value("PLOT_STYLE_NUMPAD_1_ANGLED", PLOT_STYLE_NUMPAD_1_ANGLED)
		.value("PLOT_STYLE_NUMPAD_2_ANGLED", PLOT_STYLE_NUMPAD_2_ANGLED)
		.value("PLOT_STYLE_NUMPAD_3_ANGLED", PLOT_STYLE_NUMPAD_3_ANGLED)
		.value("PLOT_STYLE_NUMPAD_4_ANGLED", PLOT_STYLE_NUMPAD_4_ANGLED)
		.value("PLOT_STYLE_NUMPAD_6_ANGLED", PLOT_STYLE_NUMPAD_6_ANGLED)
		.value("PLOT_STYLE_NUMPAD_7_ANGLED", PLOT_STYLE_NUMPAD_7_ANGLED)
		.value("PLOT_STYLE_NUMPAD_8_ANGLED", PLOT_STYLE_NUMPAD_8_ANGLED)
		.value("PLOT_STYLE_NUMPAD_9_ANGLED", PLOT_STYLE_NUMPAD_9_ANGLED)
		.value("PLOT_STYLE_BOX_FILL", PLOT_STYLE_BOX_FILL)
		.value("PLOT_STYLE_BOX_OUTLINE", PLOT_STYLE_BOX_OUTLINE)
		.value("PLOT_STYLE_RIVER_SOUTH", PLOT_STYLE_RIVER_SOUTH)
		.value("PLOT_STYLE_RIVER_EAST", PLOT_STYLE_RIVER_EAST)
		.value("PLOT_STYLE_SIDE_ARROWS", PLOT_STYLE_SIDE_ARROWS)
		.value("PLOT_STYLE_CIRCLE", PLOT_STYLE_CIRCLE)
		.value("PLOT_STYLE_TARGET", PLOT_STYLE_TARGET)
		.value("PLOT_STYLE_DOT_TARGET", PLOT_STYLE_DOT_TARGET)
		.value("PLOT_STYLE_WAVES", PLOT_STYLE_WAVES)
		.value("PLOT_STYLE_DOTS", PLOT_STYLE_DOTS)
		.value("PLOT_STYLE_CIRCLES", PLOT_STYLE_CIRCLES)
		;

	python::enum_<PlotLandscapeLayers>("PlotLandscapeLayers")
		.value("PLOT_LANDSCAPE_LAYER_ALL", PLOT_LANDSCAPE_LAYER_ALL)
		.value("PLOT_LANDSCAPE_LAYER_BASE", PLOT_LANDSCAPE_LAYER_BASE)
		.value("PLOT_LANDSCAPE_LAYER_RECOMMENDED_PLOTS", PLOT_LANDSCAPE_LAYER_RECOMMENDED_PLOTS)
		.value("PLOT_LANDSCAPE_LAYER_WORLD_BUILDER", PLOT_LANDSCAPE_LAYER_WORLD_BUILDER)
		.value("PLOT_LANDSCAPE_LAYER_NUMPAD_HELP", PLOT_LANDSCAPE_LAYER_NUMPAD_HELP)
		.value("PLOT_LANDSCAPE_LAYER_REVEALED_PLOTS", PLOT_LANDSCAPE_LAYER_REVEALED_PLOTS)
		;

	python::enum_<AreaBorderLayers>("AreaBorderLayers")
		.value("AREA_BORDER_LAYER_REVEALED_PLOTS", AREA_BORDER_LAYER_REVEALED_PLOTS)
		.value("AREA_BORDER_LAYER_WORLD_BUILDER", AREA_BORDER_LAYER_WORLD_BUILDER)
		.value("AREA_BORDER_LAYER_FOUNDING_BORDER", AREA_BORDER_LAYER_FOUNDING_BORDER)
		.value("AREA_BORDER_LAYER_CITY_RADIUS", AREA_BORDER_LAYER_CITY_RADIUS)
		.value("AREA_BORDER_LAYER_RANGED", AREA_BORDER_LAYER_RANGED)
		.value("AREA_BORDER_LAYER_HIGHLIGHT_PLOT", AREA_BORDER_LAYER_HIGHLIGHT_PLOT)
		.value("AREA_BORDER_LAYER_BLOCKADING", AREA_BORDER_LAYER_BLOCKADING)
		.value("AREA_BORDER_LAYER_BLOCKADED", AREA_BORDER_LAYER_BLOCKADED)
		.value("NUM_AREA_BORDER_LAYERS", NUM_AREA_BORDER_LAYERS)
		;

	python::enum_<InterfaceModeTypes>("InterfaceModeTypes")
		.value("NO_INTERFACEMODE", NO_INTERFACEMODE)
		.value("INTERFACEMODE_SELECTION", INTERFACEMODE_SELECTION)
		.value("INTERFACEMODE_PING", INTERFACEMODE_PING)
		.value("INTERFACEMODE_SIGN", INTERFACEMODE_SIGN)
		.value("INTERFACEMODE_GRIP", INTERFACEMODE_GRIP)
		.value("INTERFACEMODE_GLOBELAYER_INPUT", INTERFACEMODE_GLOBELAYER_INPUT)
		.value("INTERFACEMODE_GO_TO", INTERFACEMODE_GO_TO)
		.value("INTERFACEMODE_GO_TO_TYPE", INTERFACEMODE_GO_TO_TYPE)
		.value("INTERFACEMODE_GO_TO_ALL", INTERFACEMODE_GO_TO_ALL)
		.value("INTERFACEMODE_ROUTE_TO", INTERFACEMODE_ROUTE_TO)
		.value("INTERFACEMODE_AIRLIFT", INTERFACEMODE_AIRLIFT)
		.value("INTERFACEMODE_NUKE", INTERFACEMODE_NUKE)
		.value("INTERFACEMODE_RECON", INTERFACEMODE_RECON)
		.value("INTERFACEMODE_PARADROP", INTERFACEMODE_PARADROP)
		.value("INTERFACEMODE_AIRBOMB", INTERFACEMODE_AIRBOMB)
		.value("INTERFACEMODE_RANGE_ATTACK", INTERFACEMODE_RANGE_ATTACK)
		.value("INTERFACEMODE_AIRSTRIKE", INTERFACEMODE_AIRSTRIKE)
		.value("INTERFACEMODE_REBASE", INTERFACEMODE_REBASE)
		.value("INTERFACEMODE_PYTHON_PICK_PLOT", INTERFACEMODE_PYTHON_PICK_PLOT)
		.value("INTERFACEMODE_SAVE_PLOT_NIFS", INTERFACEMODE_SAVE_PLOT_NIFS)
		.value("INTERFACEMODE_AIRBOMB1", INTERFACEMODE_AIRBOMB1)
		.value("INTERFACEMODE_AIRBOMB2", INTERFACEMODE_AIRBOMB2)
		.value("INTERFACEMODE_AIRBOMB3", INTERFACEMODE_AIRBOMB3)
		.value("INTERFACEMODE_AIRBOMB4", INTERFACEMODE_AIRBOMB4)
		.value("INTERFACEMODE_AIRBOMB5", INTERFACEMODE_AIRBOMB5)
		.value("NUM_INTERFACEMODE_TYPES", NUM_INTERFACEMODE_TYPES)
		;

	python::enum_<InterfaceMessageTypes>("InterfaceMessageTypes")
		.value("NO_MESSAGE_TYPE", NO_MESSAGE_TYPE)
		.value("MESSAGE_TYPE_INFO", MESSAGE_TYPE_INFO)
		.value("MESSAGE_TYPE_DISPLAY_ONLY", MESSAGE_TYPE_DISPLAY_ONLY)
		.value("MESSAGE_TYPE_MAJOR_EVENT", MESSAGE_TYPE_MAJOR_EVENT)
		.value("MESSAGE_TYPE_MINOR_EVENT", MESSAGE_TYPE_MINOR_EVENT)
		.value("MESSAGE_TYPE_CHAT", MESSAGE_TYPE_CHAT)
		.value("MESSAGE_TYPE_COMBAT_MESSAGE", MESSAGE_TYPE_COMBAT_MESSAGE)
		.value("MESSAGE_TYPE_QUEST", MESSAGE_TYPE_QUEST)
		.value("NUM_INTERFACE_MESSAGE_TYPES", NUM_INTERFACE_MESSAGE_TYPES)
		;

	python::enum_<MinimapModeTypes>("MinimapModeTypes")
		.value("NO_MINIMAPMODE", NO_MINIMAPMODE)
		.value("MINIMAPMODE_TERRITORY", MINIMAPMODE_TERRITORY)
		.value("MINIMAPMODE_TERRAIN", MINIMAPMODE_TERRAIN)
		.value("MINIMAPMODE_REPLAY", MINIMAPMODE_REPLAY)
		.value("MINIMAPMODE_MILITARY", MINIMAPMODE_MILITARY)
		.value("NUM_MINIMAPMODE_TYPES", NUM_MINIMAPMODE_TYPES)
		;

	python::enum_<EngineDirtyBits>("EngineDirtyBits")
		.value("GlobeTexture_DIRTY_BIT", GlobeTexture_DIRTY_BIT)
		.value("MinimapTexture_DIRTY_BIT", MinimapTexture_DIRTY_BIT)
		.value("CultureBorders_DIRTY_BIT", CultureBorders_DIRTY_BIT)
		.value("NUM_ENGINE_DIRTY_BITS", NUM_ENGINE_DIRTY_BITS)
		;

	python::enum_<InterfaceDirtyBits>("InterfaceDirtyBits")
		.value("SelectionCamera_DIRTY_BIT", SelectionCamera_DIRTY_BIT)
		.value("Fog_DIRTY_BIT", Fog_DIRTY_BIT)
		.value("GlobeLayer_DIRTY_BIT", GlobeLayer_DIRTY_BIT)
		.value("GlobeInfo_DIRTY_BIT", GlobeInfo_DIRTY_BIT)
		.value("Waypoints_DIRTY_BIT", Waypoints_DIRTY_BIT)
		.value("PercentButtons_DIRTY_BIT", PercentButtons_DIRTY_BIT)
		.value("MiscButtons_DIRTY_BIT", MiscButtons_DIRTY_BIT)
		.value("PlotListButtons_DIRTY_BIT", PlotListButtons_DIRTY_BIT)
		.value("SelectionButtons_DIRTY_BIT", SelectionButtons_DIRTY_BIT)
		.value("CitizenButtons_DIRTY_BIT", CitizenButtons_DIRTY_BIT)
		.value("ResearchButtons_DIRTY_BIT", ResearchButtons_DIRTY_BIT)
		.value("Event_DIRTY_BIT", Event_DIRTY_BIT)
		.value("Center_DIRTY_BIT", Center_DIRTY_BIT)
		.value("GameData_DIRTY_BIT", GameData_DIRTY_BIT)
		.value("Score_DIRTY_BIT", Score_DIRTY_BIT)
		.value("TurnTimer_DIRTY_BIT", TurnTimer_DIRTY_BIT)
		.value("Help_DIRTY_BIT", Help_DIRTY_BIT)
		.value("MinimapSection_DIRTY_BIT", MinimapSection_DIRTY_BIT)
		.value("SelectionSound_DIRTY_BIT", SelectionSound_DIRTY_BIT)
		.value("Cursor_DIRTY_BIT", Cursor_DIRTY_BIT)
		.value("CityInfo_DIRTY_BIT", CityInfo_DIRTY_BIT)
		.value("UnitInfo_DIRTY_BIT", UnitInfo_DIRTY_BIT)
		.value("Popup_DIRTY_BIT", Popup_DIRTY_BIT)
		.value("CityScreen_DIRTY_BIT", CityScreen_DIRTY_BIT)
		.value("InfoPane_DIRTY_BIT", InfoPane_DIRTY_BIT)
		.value("Flag_DIRTY_BIT", Flag_DIRTY_BIT)
		.value("HighlightPlot_DIRTY_BIT", HighlightPlot_DIRTY_BIT)
		.value("ColoredPlots_DIRTY_BIT", ColoredPlots_DIRTY_BIT)
		.value("BlockadedPlots_DIRTY_BIT", BlockadedPlots_DIRTY_BIT)
		.value("Financial_Screen_DIRTY_BIT", Financial_Screen_DIRTY_BIT)
		.value("Foreign_Screen_DIRTY_BIT", Foreign_Screen_DIRTY_BIT)
		.value("Soundtrack_DIRTY_BIT", Soundtrack_DIRTY_BIT)
		.value("Domestic_Advisor_DIRTY_BIT", Domestic_Advisor_DIRTY_BIT)
		.value("Espionage_Advisor_DIRTY_BIT", Espionage_Advisor_DIRTY_BIT)
		.value("Advanced_Start_DIRTY_BIT", Advanced_Start_DIRTY_BIT)
		.value("NUM_INTERFACE_DIRTY_BITS", NUM_INTERFACE_DIRTY_BITS)
		;

	python::enum_<CityTabTypes>("CityTabTypes")
		.value("CITYTAB_UNITS", CITYTAB_UNITS)
		.value("CITYTAB_BUILDINGS", CITYTAB_BUILDINGS)
		.value("CITYTAB_WONDERS", CITYTAB_WONDERS)
		.value("NUM_CITYTAB_TYPES", NUM_CITYTAB_TYPES)
		;

	python::enum_<WidgetTypes>("WidgetTypes")
		.value("WIDGET_PLOT_LIST", WIDGET_PLOT_LIST)
		.value("WIDGET_PLOT_LIST_SHIFT", WIDGET_PLOT_LIST_SHIFT)
		.value("WIDGET_CITY_SCROLL", WIDGET_CITY_SCROLL)
		.value("WIDGET_LIBERATE_CITY", WIDGET_LIBERATE_CITY)
		.value("WIDGET_CITY_NAME", WIDGET_CITY_NAME)
		.value("WIDGET_UNIT_NAME", WIDGET_UNIT_NAME)
		.value("WIDGET_CREATE_GROUP", WIDGET_CREATE_GROUP)
		.value("WIDGET_DELETE_GROUP", WIDGET_DELETE_GROUP)
		.value("WIDGET_TRAIN", WIDGET_TRAIN)
		.value("WIDGET_CONSTRUCT", WIDGET_CONSTRUCT)
		.value("WIDGET_CREATE", WIDGET_CREATE)
		.value("WIDGET_MAINTAIN", WIDGET_MAINTAIN)
		.value("WIDGET_HURRY", WIDGET_HURRY)
		.value("WIDGET_MENU_ICON", WIDGET_MENU_ICON)
		.value("WIDGET_CONSCRIPT", WIDGET_CONSCRIPT)
		.value("WIDGET_ACTION", WIDGET_ACTION)
		.value("WIDGET_DISABLED_CITIZEN", WIDGET_DISABLED_CITIZEN)
		.value("WIDGET_CITIZEN", WIDGET_CITIZEN)
		.value("WIDGET_FREE_CITIZEN", WIDGET_FREE_CITIZEN)
		.value("WIDGET_ANGRY_CITIZEN", WIDGET_ANGRY_CITIZEN)
		.value("WIDGET_CHANGE_SPECIALIST", WIDGET_CHANGE_SPECIALIST)
		.value("WIDGET_RESEARCH", WIDGET_RESEARCH)
		.value("WIDGET_TECH_TREE", WIDGET_TECH_TREE)
		.value("WIDGET_CHANGE_PERCENT", WIDGET_CHANGE_PERCENT)
		.value("WIDGET_CITY_TAB", WIDGET_CITY_TAB)
		.value("WIDGET_CONTACT_CIV", WIDGET_CONTACT_CIV)
		.value("WIDGET_SCORE_BREAKDOWN", WIDGET_SCORE_BREAKDOWN)
		.value("WIDGET_ZOOM_CITY", WIDGET_ZOOM_CITY)
		.value("WIDGET_END_TURN", WIDGET_END_TURN)
		.value("WIDGET_LAUNCH_VICTORY", WIDGET_LAUNCH_VICTORY)
		.value("WIDGET_CONVERT", WIDGET_CONVERT)
		.value("WIDGET_WB_SAVE_BUTTON", WIDGET_WB_SAVE_BUTTON)
		.value("WIDGET_WB_LOAD_BUTTON", WIDGET_WB_LOAD_BUTTON)
		.value("WIDGET_WB_ALL_PLOTS_BUTTON", WIDGET_WB_ALL_PLOTS_BUTTON)
		.value("WIDGET_WB_LANDMARK_BUTTON", WIDGET_WB_LANDMARK_BUTTON)
		.value("WIDGET_WB_ERASE_BUTTON", WIDGET_WB_ERASE_BUTTON)
		.value("WIDGET_WB_EXIT_BUTTON", WIDGET_WB_EXIT_BUTTON)
		.value("WIDGET_WB_UNIT_EDIT_BUTTON", WIDGET_WB_UNIT_EDIT_BUTTON)
		.value("WIDGET_WB_CITY_EDIT_BUTTON", WIDGET_WB_CITY_EDIT_BUTTON)
		.value("WIDGET_WB_NORMAL_PLAYER_TAB_MODE_BUTTON", WIDGET_WB_NORMAL_PLAYER_TAB_MODE_BUTTON)
		.value("WIDGET_WB_NORMAL_MAP_TAB_MODE_BUTTON", WIDGET_WB_NORMAL_MAP_TAB_MODE_BUTTON)
		.value("WIDGET_WB_REVEAL_TAB_MODE_BUTTON", WIDGET_WB_REVEAL_TAB_MODE_BUTTON)
		.value("WIDGET_WB_DIPLOMACY_MODE_BUTTON", WIDGET_WB_DIPLOMACY_MODE_BUTTON)
		.value("WIDGET_WB_REVEAL_ALL_BUTTON", WIDGET_WB_REVEAL_ALL_BUTTON)
		.value("WIDGET_WB_UNREVEAL_ALL_BUTTON", WIDGET_WB_UNREVEAL_ALL_BUTTON)
		.value("WIDGET_WB_REGENERATE_MAP", WIDGET_WB_REGENERATE_MAP)
		.value("WIDGET_AUTOMATE_CITIZENS", WIDGET_AUTOMATE_CITIZENS)
		.value("WIDGET_AUTOMATE_PRODUCTION", WIDGET_AUTOMATE_PRODUCTION)
		.value("WIDGET_EMPHASIZE", WIDGET_EMPHASIZE)
		.value("WIDGET_DIPLOMACY_RESPONSE", WIDGET_DIPLOMACY_RESPONSE)
		.value("WIDGET_GENERAL", WIDGET_GENERAL)
		.value("WIDGET_FILE_LISTBOX", WIDGET_FILE_LISTBOX)
		.value("WIDGET_FILE_EDITBOX", WIDGET_FILE_EDITBOX)
		.value("WIDGET_TRADE_ITEM", WIDGET_TRADE_ITEM)
		.value("WIDGET_UNIT_MODEL", WIDGET_UNIT_MODEL)
		.value("WIDGET_FLAG", WIDGET_FLAG)
		.value("WIDGET_POPUP_QUEUE", WIDGET_POPUP_QUEUE)
		.value("WIDGET_PYTHON", WIDGET_PYTHON)
		.value("WIDGET_HELP_MAINTENANCE", WIDGET_HELP_MAINTENANCE)
		.value("WIDGET_HELP_RELIGION", WIDGET_HELP_RELIGION)
		.value("WIDGET_HELP_RELIGION_CITY", WIDGET_HELP_RELIGION_CITY)
		.value("WIDGET_HELP_CORPORATION_CITY", WIDGET_HELP_CORPORATION_CITY)
		.value("WIDGET_HELP_NATIONALITY", WIDGET_HELP_NATIONALITY)
		.value("WIDGET_HELP_DEFENSE", WIDGET_HELP_DEFENSE)
		.value("WIDGET_HELP_HEALTH", WIDGET_HELP_HEALTH)
		.value("WIDGET_HELP_HAPPINESS", WIDGET_HELP_HAPPINESS)
		.value("WIDGET_HELP_POPULATION", WIDGET_HELP_POPULATION)
		.value("WIDGET_HELP_PRODUCTION", WIDGET_HELP_PRODUCTION)
		.value("WIDGET_HELP_CULTURE", WIDGET_HELP_CULTURE)
		.value("WIDGET_HELP_GREAT_PEOPLE", WIDGET_HELP_GREAT_PEOPLE)
		.value("WIDGET_HELP_GREAT_GENERAL", WIDGET_HELP_GREAT_GENERAL)
		.value("WIDGET_HELP_SELECTED", WIDGET_HELP_SELECTED)
		.value("WIDGET_HELP_BUILDING", WIDGET_HELP_BUILDING)
		.value("WIDGET_HELP_TRADE_ROUTE_CITY", WIDGET_HELP_TRADE_ROUTE_CITY)
		.value("WIDGET_HELP_ESPIONAGE_COST", WIDGET_HELP_ESPIONAGE_COST)
		.value("WIDGET_HELP_TECH_ENTRY", WIDGET_HELP_TECH_ENTRY)
		.value("WIDGET_HELP_TECH_PREPREQ", WIDGET_HELP_TECH_PREPREQ)
		.value("WIDGET_HELP_OBSOLETE", WIDGET_HELP_OBSOLETE)
		.value("WIDGET_HELP_OBSOLETE_BONUS", WIDGET_HELP_OBSOLETE_BONUS)
		.value("WIDGET_HELP_OBSOLETE_SPECIAL", WIDGET_HELP_OBSOLETE_SPECIAL)
		.value("WIDGET_HELP_MOVE_BONUS", WIDGET_HELP_MOVE_BONUS)
		.value("WIDGET_HELP_FREE_UNIT", WIDGET_HELP_FREE_UNIT)
		.value("WIDGET_HELP_FEATURE_PRODUCTION", WIDGET_HELP_FEATURE_PRODUCTION)
		.value("WIDGET_HELP_WORKER_RATE", WIDGET_HELP_WORKER_RATE)
		.value("WIDGET_HELP_TRADE_ROUTES", WIDGET_HELP_TRADE_ROUTES)
		.value("WIDGET_HELP_HEALTH_RATE", WIDGET_HELP_HEALTH_RATE)
		.value("WIDGET_HELP_HAPPINESS_RATE", WIDGET_HELP_HAPPINESS_RATE)
		.value("WIDGET_HELP_FREE_TECH", WIDGET_HELP_FREE_TECH)
		.value("WIDGET_HELP_LOS_BONUS", WIDGET_HELP_LOS_BONUS)
		.value("WIDGET_HELP_MAP_CENTER", WIDGET_HELP_MAP_CENTER)
		.value("WIDGET_HELP_MAP_REVEAL", WIDGET_HELP_MAP_REVEAL)
		.value("WIDGET_HELP_MAP_TRADE", WIDGET_HELP_MAP_TRADE)
		.value("WIDGET_HELP_TECH_TRADE", WIDGET_HELP_TECH_TRADE)
		.value("WIDGET_HELP_GOLD_TRADE", WIDGET_HELP_GOLD_TRADE)
		.value("WIDGET_HELP_OPEN_BORDERS", WIDGET_HELP_OPEN_BORDERS)
		.value("WIDGET_HELP_DEFENSIVE_PACT", WIDGET_HELP_DEFENSIVE_PACT)
		.value("WIDGET_HELP_PERMANENT_ALLIANCE", WIDGET_HELP_PERMANENT_ALLIANCE)
		.value("WIDGET_HELP_VASSAL_STATE", WIDGET_HELP_VASSAL_STATE)
		.value("WIDGET_HELP_BUILD_BRIDGE", WIDGET_HELP_BUILD_BRIDGE)
		.value("WIDGET_HELP_IRRIGATION", WIDGET_HELP_IRRIGATION)
		.value("WIDGET_HELP_IGNORE_IRRIGATION", WIDGET_HELP_IGNORE_IRRIGATION)
		.value("WIDGET_HELP_WATER_WORK", WIDGET_HELP_WATER_WORK)
		.value("WIDGET_HELP_IMPROVEMENT", WIDGET_HELP_IMPROVEMENT)
		.value("WIDGET_HELP_DOMAIN_EXTRA_MOVES", WIDGET_HELP_DOMAIN_EXTRA_MOVES)
		.value("WIDGET_HELP_ADJUST", WIDGET_HELP_ADJUST)
		.value("WIDGET_HELP_TERRAIN_TRADE", WIDGET_HELP_TERRAIN_TRADE)
		.value("WIDGET_HELP_SPECIAL_BUILDING", WIDGET_HELP_SPECIAL_BUILDING)
		.value("WIDGET_HELP_YIELD_CHANGE", WIDGET_HELP_YIELD_CHANGE)
		.value("WIDGET_HELP_BONUS_REVEAL", WIDGET_HELP_BONUS_REVEAL)
		.value("WIDGET_HELP_CIVIC_REVEAL", WIDGET_HELP_CIVIC_REVEAL)
		.value("WIDGET_HELP_PROCESS_INFO", WIDGET_HELP_PROCESS_INFO)
		.value("WIDGET_HELP_FOUND_RELIGION", WIDGET_HELP_FOUND_RELIGION)
		.value("WIDGET_HELP_FOUND_CORPORATION", WIDGET_HELP_FOUND_CORPORATION)
		.value("WIDGET_HELP_FINANCE_NUM_UNITS", WIDGET_HELP_FINANCE_NUM_UNITS)
		.value("WIDGET_HELP_FINANCE_UNIT_COST", WIDGET_HELP_FINANCE_UNIT_COST)
		.value("WIDGET_HELP_FINANCE_AWAY_SUPPLY", WIDGET_HELP_FINANCE_AWAY_SUPPLY)
		.value("WIDGET_HELP_FINANCE_CITY_MAINT", WIDGET_HELP_FINANCE_CITY_MAINT)
		.value("WIDGET_HELP_FINANCE_CIVIC_UPKEEP", WIDGET_HELP_FINANCE_CIVIC_UPKEEP)
		.value("WIDGET_HELP_FINANCE_FOREIGN_INCOME", WIDGET_HELP_FINANCE_FOREIGN_INCOME)
		.value("WIDGET_HELP_FINANCE_INFLATED_COSTS", WIDGET_HELP_FINANCE_INFLATED_COSTS)
		.value("WIDGET_HELP_FINANCE_GROSS_INCOME", WIDGET_HELP_FINANCE_GROSS_INCOME)
		.value("WIDGET_HELP_FINANCE_NET_GOLD", WIDGET_HELP_FINANCE_NET_GOLD)
		.value("WIDGET_HELP_FINANCE_GOLD_RESERVE", WIDGET_HELP_FINANCE_GOLD_RESERVE)
		.value("WIDGET_HELP_PROMOTION", WIDGET_HELP_PROMOTION)
		.value("WIDGET_CHOOSE_EVENT", WIDGET_CHOOSE_EVENT)
		.value("WIDGET_PEDIA_JUMP_TO_TECH", WIDGET_PEDIA_JUMP_TO_TECH)
		.value("WIDGET_PEDIA_JUMP_TO_UNIT", WIDGET_PEDIA_JUMP_TO_UNIT)
		.value("WIDGET_PEDIA_JUMP_TO_BUILDING", WIDGET_PEDIA_JUMP_TO_BUILDING)
		.value("WIDGET_PEDIA_JUMP_TO_DERIVED_TECH", WIDGET_PEDIA_JUMP_TO_DERIVED_TECH)
		.value("WIDGET_PEDIA_JUMP_TO_REQUIRED_TECH", WIDGET_PEDIA_JUMP_TO_REQUIRED_TECH)
		.value("WIDGET_PEDIA_BACK", WIDGET_PEDIA_BACK)
		.value("WIDGET_PEDIA_FORWARD", WIDGET_PEDIA_FORWARD)
		.value("WIDGET_PEDIA_JUMP_TO_BONUS", WIDGET_PEDIA_JUMP_TO_BONUS)
		.value("WIDGET_PEDIA_MAIN", WIDGET_PEDIA_MAIN)
		.value("WIDGET_PEDIA_JUMP_TO_PROMOTION", WIDGET_PEDIA_JUMP_TO_PROMOTION)
		.value("WIDGET_PEDIA_JUMP_TO_UNIT_COMBAT", WIDGET_PEDIA_JUMP_TO_UNIT_COMBAT)
		.value("WIDGET_PEDIA_JUMP_TO_IMPROVEMENT", WIDGET_PEDIA_JUMP_TO_IMPROVEMENT)		
		.value("WIDGET_PEDIA_JUMP_TO_CIVIC", WIDGET_PEDIA_JUMP_TO_CIVIC)		
		.value("WIDGET_PEDIA_JUMP_TO_CIV", WIDGET_PEDIA_JUMP_TO_CIV)		
		.value("WIDGET_PEDIA_JUMP_TO_LEADER", WIDGET_PEDIA_JUMP_TO_LEADER)		
		.value("WIDGET_PEDIA_JUMP_TO_SPECIALIST", WIDGET_PEDIA_JUMP_TO_SPECIALIST)		
		.value("WIDGET_PEDIA_JUMP_TO_PROJECT", WIDGET_PEDIA_JUMP_TO_PROJECT)		
		.value("WIDGET_PEDIA_JUMP_TO_TERRAIN", WIDGET_PEDIA_JUMP_TO_TERRAIN)		
		.value("WIDGET_PEDIA_JUMP_TO_FEATURE", WIDGET_PEDIA_JUMP_TO_FEATURE)		
		.value("WIDGET_TURN_EVENT", WIDGET_TURN_EVENT)
		.value("WIDGET_FOREIGN_ADVISOR", WIDGET_FOREIGN_ADVISOR)
		.value("WIDGET_REVOLUTION", WIDGET_REVOLUTION)
		.value("WIDGET_PEDIA_DESCRIPTION", WIDGET_PEDIA_DESCRIPTION)
		.value("WIDGET_PEDIA_DESCRIPTION_NO_HELP", WIDGET_PEDIA_DESCRIPTION_NO_HELP)
		.value("WIDGET_DEAL_KILL", WIDGET_DEAL_KILL)
		.value("WIDGET_MINIMAP_HIGHLIGHT", WIDGET_MINIMAP_HIGHLIGHT)
		.value("WIDGET_PRODUCTION_MOD_HELP", WIDGET_PRODUCTION_MOD_HELP)
		.value("WIDGET_LEADERHEAD", WIDGET_LEADERHEAD)
		.value("WIDGET_LEADER_LINE", WIDGET_LEADER_LINE)
		.value("WIDGET_COMMERCE_MOD_HELP", WIDGET_COMMERCE_MOD_HELP)
		.value("WIDGET_CLOSE_SCREEN", WIDGET_CLOSE_SCREEN)
		.value("WIDGET_PEDIA_JUMP_TO_RELIGION", WIDGET_PEDIA_JUMP_TO_RELIGION)		
		.value("WIDGET_PEDIA_JUMP_TO_CORPORATION", WIDGET_PEDIA_JUMP_TO_CORPORATION)		
		.value("WIDGET_GLOBELAYER", WIDGET_GLOBELAYER)
		.value("WIDGET_GLOBELAYER_OPTION", WIDGET_GLOBELAYER_OPTION)
		.value("WIDGET_GLOBELAYER_TOGGLE", WIDGET_GLOBELAYER_TOGGLE)

		.value("NUM_WIDGET_TYPES", NUM_WIDGET_TYPES)
		//Kathy Unique Techs: Spread overall Religion
		.value("WIDGET_HELP_SPREAD_OVERALL_RELIGION", WIDGET_HELP_SPREAD_OVERALL_RELIGION)
		//Kathy Golden Age From Tech
		.value("WIDGET_HELP_GOLDEN_AGE_FROM_TECH", WIDGET_HELP_GOLDEN_AGE_FROM_TECH)
		//Kathy Golden Age From Tech
		//Kathy Steal Tech Beginn
		.value("WIDGET_HELP_STEAL_TECH", WIDGET_HELP_STEAL_TECH)
		//Kathy Steal Tech End
		//Kathy TechTransfer Beginn
		.value("WIDGET_HELP_TECH_TRANSFER", WIDGET_HELP_TECH_TRANSFER)
		//Kathy TechTransfer End
		//Kathy Kill Religion Beginn
		.value("WIDGET_HELP_KILL_RELIGION", WIDGET_HELP_KILL_RELIGION)
		//Kathy Kill Religion End
		//Kathy Columbian Exchange Beginn
//		.value("WIDGET_HELP_COLUMBIAN_EXCHANGE", WIDGET_HELP_COLUMBIAN_EXCHANGE)
		//Kathy ColumbianExchange End
		//Kathy Religious Tolerance Tech Beginn
		.value("WIDGET_RELI_TOLERANCE_TECH", WIDGET_RELI_TOLERANCE_TECH)
		//Kathy Religious Tolerance Tech End
		//Kathy Defense Modifier Tech Beginn
		.value("WIDGET_DEFENSE_TECH", WIDGET_DEFENSE_TECH)
		//Kathy Defense Modifier Tech End
		//Kathy Archaeology Modifier Tech Beginn
		.value("WIDGET_ARCHAEOLOGY_TECH", WIDGET_ARCHAEOLOGY_TECH)
		//Kathy Archaeology Modifier Tech End
		//Kathy Tourism Modifier Tech Beginn
		.value("WIDGET_TOURISM_TECH", WIDGET_TOURISM_TECH)
		//Kathy Tourism Modifier Tech End
		//Kathy partisan Tech Beginn
		.value("WIDGET_PARTISAN_TECH", WIDGET_PARTISAN_TECH)
		//Kathy partisan Tech End
		//Kathy Einheitensuppor Tech Beginn
		.value("WIDGET_FREE_UNIT_SUPPORT", WIDGET_FREE_UNIT_SUPPORT)
		//Kathy Einheitensuppor Tech End
		//Kathy InflationModifier Tech Beginn
		.value("WIDGET_INFLATION_MOD", WIDGET_INFLATION_MOD)
		//Kathy InflationModifier Tech End
		//Kathy HURRY_ANGER Tech Beginn
		.value("WIDGET_HURRY_ANGER", WIDGET_HURRY_ANGER)
		//Kathy HURRY_ANGER Tech End
		//Kathy WarWearinessModifier Tech Beginn
		.value("WIDGET_WAR_WEARINESS", WIDGET_WAR_WEARINESS)
		//Kathy WarWearinessModifier Tech End
		//Kathy attitude Tech Beginn
		.value("WIDGET_ATTITUDE_TECH", WIDGET_ATTITUDE_TECH)
		//Kathy attitude Tech End
		//Kathy attitude Tech Beginn
		.value("WIDGET_ATTITUDE_GENERAL_TECH", WIDGET_ATTITUDE_GENERAL_TECH)
		//Kathy attitude Tech End
		//Kathy Barbadian from Tech Beginn
		.value("WIDGET_HELP_BARBARIAN_UPRISING", WIDGET_HELP_BARBARIAN_UPRISING)
		//Kathy Barbadian from Tech End
		//Kathy Techs verbrauchen Bonus Beginn
		.value("WIDGET_HELP_COMSUME_BONUS", WIDGET_HELP_COMSUME_BONUS)
		//Kathy Techs verbrauchen Bonus End
		//Kathy Pollution Beginn
		.value("WIDGET_HELP_POLLUTION", WIDGET_HELP_POLLUTION)
		//Kathy Pollution End
		;

	python::enum_<ButtonPopupTypes>("ButtonPopupTypes")
		.value("BUTTONPOPUP_TEXT", BUTTONPOPUP_TEXT)
		.value("BUTTONPOPUP_MAIN_MENU", BUTTONPOPUP_MAIN_MENU)
		.value("BUTTONPOPUP_CONFIRM_MENU", BUTTONPOPUP_CONFIRM_MENU)
		.value("BUTTONPOPUP_DECLAREWARMOVE", BUTTONPOPUP_DECLAREWARMOVE)
		.value("BUTTONPOPUP_CONFIRMCOMMAND", BUTTONPOPUP_CONFIRMCOMMAND)
		.value("BUTTONPOPUP_LOADUNIT", BUTTONPOPUP_LOADUNIT)
		.value("BUTTONPOPUP_LEADUNIT", BUTTONPOPUP_LEADUNIT)
		.value("BUTTONPOPUP_DOESPIONAGE", BUTTONPOPUP_DOESPIONAGE)
		.value("BUTTONPOPUP_DOESPIONAGE_TARGET", BUTTONPOPUP_DOESPIONAGE_TARGET)
		.value("BUTTONPOPUP_CHOOSETECH", BUTTONPOPUP_CHOOSETECH)
		.value("BUTTONPOPUP_RAZECITY", BUTTONPOPUP_RAZECITY)
		.value("BUTTONPOPUP_DISBANDCITY", BUTTONPOPUP_DISBANDCITY)
		.value("BUTTONPOPUP_CHOOSEPRODUCTION", BUTTONPOPUP_CHOOSEPRODUCTION)
		.value("BUTTONPOPUP_CHANGECIVIC", BUTTONPOPUP_CHANGECIVIC)
		.value("BUTTONPOPUP_CHANGERELIGION", BUTTONPOPUP_CHANGERELIGION)
		.value("BUTTONPOPUP_CHOOSEELECTION", BUTTONPOPUP_CHOOSEELECTION)
		.value("BUTTONPOPUP_DIPLOVOTE", BUTTONPOPUP_DIPLOVOTE)
		.value("BUTTONPOPUP_ALARM", BUTTONPOPUP_ALARM)
		.value("BUTTONPOPUP_DEAL_CANCELED", BUTTONPOPUP_DEAL_CANCELED)
		.value("BUTTONPOPUP_PYTHON", BUTTONPOPUP_PYTHON)
		.value("BUTTONPOPUP_PYTHON_SCREEN", BUTTONPOPUP_PYTHON_SCREEN)
		.value("BUTTONPOPUP_DETAILS", BUTTONPOPUP_DETAILS)
		.value("BUTTONPOPUP_ADMIN", BUTTONPOPUP_ADMIN)
		.value("BUTTONPOPUP_ADMIN_PASSWORD", BUTTONPOPUP_ADMIN_PASSWORD)
		.value("BUTTONPOPUP_EXTENDED_GAME", BUTTONPOPUP_EXTENDED_GAME)
		.value("BUTTONPOPUP_DIPLOMACY", BUTTONPOPUP_DIPLOMACY)
		.value("BUTTONPOPUP_ADDBUDDY", BUTTONPOPUP_ADDBUDDY)
		.value("BUTTONPOPUP_FORCED_DISCONNECT", BUTTONPOPUP_FORCED_DISCONNECT)
		.value("BUTTONPOPUP_PITBOSS_DISCONNECT", BUTTONPOPUP_PITBOSS_DISCONNECT)
		.value("BUTTONPOPUP_KICKED", BUTTONPOPUP_PITBOSS_DISCONNECT)
		.value("BUTTONPOPUP_VASSAL_DEMAND_TRIBUTE", BUTTONPOPUP_VASSAL_DEMAND_TRIBUTE)
		.value("BUTTONPOPUP_VASSAL_GRANT_TRIBUTE", BUTTONPOPUP_VASSAL_GRANT_TRIBUTE)
		.value("BUTTONPOPUP_EVENT", BUTTONPOPUP_EVENT)
		.value("BUTTONPOPUP_FREE_COLONY", BUTTONPOPUP_FREE_COLONY)
		.value("BUTTONPOPUP_LAUNCH", BUTTONPOPUP_LAUNCH)
		.value("BUTTONPOPUP_FOUND_RELIGION", BUTTONPOPUP_FOUND_RELIGION)

		.value("NUM_BUTTONPOPUP_TYPES", NUM_BUTTONPOPUP_TYPES)
		;

	python::enum_<ClimateTypes>("ClimateTypes")
		.value("NO_CLIMATE", NO_CLIMATE)
		;

	python::enum_<SeaLevelTypes>("SeaLevelTypes")
		.value("NO_SEALEVEL", NO_SEALEVEL)
		;

	python::enum_<CustomMapOptionTypes>("CustomMapOptionTypes")
		.value("NO_CUSTOM_MAPOPTION", NO_CUSTOM_MAPOPTION)
		;

	python::enum_<WorldSizeTypes>("WorldSizeTypes")
		.value("NO_WORLDSIZE", NO_WORLDSIZE)
		.value("WORLDSIZE_DUEL", WORLDSIZE_DUEL)
		.value("WORLDSIZE_TINY", WORLDSIZE_TINY)
		.value("WORLDSIZE_SMALL", WORLDSIZE_SMALL)
		.value("WORLDSIZE_STANDARD", WORLDSIZE_STANDARD)
		.value("WORLDSIZE_LARGE", WORLDSIZE_LARGE)
		.value("WORLDSIZE_HUGE", WORLDSIZE_HUGE)
		.value("NUM_WORLDSIZE_TYPES", NUM_WORLDSIZE_TYPES)
		;

	python::enum_<TerrainTypes>("TerrainTypes")
		.value("NO_TERRAIN", NO_TERRAIN)
		;

	python::enum_<PlotTypes>("PlotTypes")
		.value("NO_PLOT", NO_PLOT)
		.value("PLOT_PEAK", PLOT_PEAK)
		.value("PLOT_HILLS", PLOT_HILLS)
		.value("PLOT_LAND", PLOT_LAND)
		.value("PLOT_OCEAN", PLOT_OCEAN)
		.value("NUM_PLOT_TYPES", NUM_PLOT_TYPES)
		;

	python::enum_<YieldTypes>("YieldTypes")
		.value("NO_YIELD", NO_YIELD)
		.value("YIELD_FOOD", YIELD_FOOD)
		.value("YIELD_PRODUCTION", YIELD_PRODUCTION)
		.value("YIELD_COMMERCE", YIELD_COMMERCE)
		//Kathy Beginn Pollution
		.value("YIELD_POLLUTION", YIELD_POLLUTION)
		//Kathy End Pollution
		.value("NUM_YIELD_TYPES", NUM_YIELD_TYPES)
		;

	python::enum_<CommerceTypes>("CommerceTypes")
		.value("COMMERCE_GOLD", COMMERCE_GOLD)
		.value("COMMERCE_RESEARCH", COMMERCE_RESEARCH)
		.value("COMMERCE_CULTURE", COMMERCE_CULTURE)
		.value("COMMERCE_ESPIONAGE", COMMERCE_ESPIONAGE)
		.value("NUM_COMMERCE_TYPES", NUM_COMMERCE_TYPES)
		;

	python::enum_<AdvisorTypes>("AdvisorTypes")
		.value("NO_ADVISOR", NO_ADVISOR)
		;

	python::enum_<FlavorTypes>("FlavorTypes")
		.value("NO_FLAVOR", NO_FLAVOR)
		;

	python::enum_<EmphasizeTypes>("EmphasizeTypes")
		.value("NO_EMPHASIZE", NO_EMPHASIZE)
		;

	python::enum_<GameOptionTypes>("GameOptionTypes")
		.value("NO_GAMEOPTION", NO_GAMEOPTION)
		.value("GAMEOPTION_ADVANCED_START", GAMEOPTION_ADVANCED_START)
		.value("GAMEOPTION_NO_CITY_RAZING", GAMEOPTION_NO_CITY_RAZING)
		.value("GAMEOPTION_NO_CITY_FLIPPING", GAMEOPTION_NO_CITY_FLIPPING)
		.value("GAMEOPTION_FLIPPING_AFTER_CONQUEST", GAMEOPTION_FLIPPING_AFTER_CONQUEST)
		.value("GAMEOPTION_NO_BARBARIANS", GAMEOPTION_NO_BARBARIANS)
		.value("GAMEOPTION_RAGING_BARBARIANS", GAMEOPTION_RAGING_BARBARIANS)
		.value("GAMEOPTION_AGGRESSIVE_AI", GAMEOPTION_AGGRESSIVE_AI)
		.value("GAMEOPTION_LEAD_ANY_CIV", GAMEOPTION_LEAD_ANY_CIV)
		.value("GAMEOPTION_RANDOM_PERSONALITIES", GAMEOPTION_RANDOM_PERSONALITIES)
		.value("GAMEOPTION_PICK_RELIGION", GAMEOPTION_PICK_RELIGION)
		.value("GAMEOPTION_NO_TECH_TRADING", GAMEOPTION_NO_TECH_TRADING)
		.value("GAMEOPTION_NO_TECH_BROKERING", GAMEOPTION_NO_TECH_BROKERING)
		.value("GAMEOPTION_PERMANENT_ALLIANCES", GAMEOPTION_PERMANENT_ALLIANCES)
		.value("GAMEOPTION_ALWAYS_WAR", GAMEOPTION_ALWAYS_WAR)
		.value("GAMEOPTION_ALWAYS_PEACE", GAMEOPTION_ALWAYS_PEACE)
		.value("GAMEOPTION_ONE_CITY_CHALLENGE", GAMEOPTION_ONE_CITY_CHALLENGE)
		.value("GAMEOPTION_NO_CHANGING_WAR_PEACE", GAMEOPTION_NO_CHANGING_WAR_PEACE)
		.value("GAMEOPTION_NEW_RANDOM_SEED", GAMEOPTION_NEW_RANDOM_SEED)
		.value("GAMEOPTION_LOCK_MODS", GAMEOPTION_LOCK_MODS)
		.value("GAMEOPTION_COMPLETE_KILLS", GAMEOPTION_COMPLETE_KILLS)
		.value("GAMEOPTION_NO_VASSAL_STATES", GAMEOPTION_NO_VASSAL_STATES)
		.value("GAMEOPTION_NO_GOODY_HUTS", GAMEOPTION_NO_GOODY_HUTS)
		.value("GAMEOPTION_NO_EVENTS", GAMEOPTION_NO_EVENTS)
		.value("GAMEOPTION_NO_ESPIONAGE", GAMEOPTION_NO_ESPIONAGE)
/********************************************************************************
*																				*
*	Lemon's Spy Mod  - Lemon Merchant - 05/31/12								*
*																				*
*	Spies return to nearest player city, rather than capital					*
*																				*
********************************************************************************/
		.value("GAMEOPTION_SPIES_RETURN_TO_NEAREST_CITY", GAMEOPTION_SPIES_RETURN_TO_NEAREST_CITY)
/************************************************************************************************/
/* LM	                     END                                                            */
/************************************************************************************************/
		.value("GAMEOPTION_SUPER_SPIES", GAMEOPTION_SUPER_SPIES)//Super Spies Game Option by Stolenrays
		//Kathy Beginn Spawn New Civs
		.value("GAMEOPTION_SPAWN_NEW_CIVS", GAMEOPTION_SPAWN_NEW_CIVS)
		//Kathy End Spawn New Civs
		//Kathy Beginn Dynamic Handycap Level
		.value("GAMEOPTION_DYNAMIC_HANDICAP_LEVEL", GAMEOPTION_DYNAMIC_HANDICAP_LEVEL)
		//Kathy End Dynamic Handycap Level
		//Kathy Stack Limit New Civs
//		.value("GAMEOPTION_STACK_LIMIT", GAMEOPTION_STACK_LIMIT)
		//Kathy Stack Limit New Civs
		.value("NUM_GAMEOPTION_TYPES", NUM_GAMEOPTION_TYPES)
		;

	python::enum_<MultiplayerOptionTypes>("MultiplayerOptionTypes")
		.value("NO_MPOPTION", NO_MPOPTION)
		.value("MPOPTION_SIMULTANEOUS_TURNS", MPOPTION_SIMULTANEOUS_TURNS)
		.value("MPOPTION_TAKEOVER_AI", MPOPTION_TAKEOVER_AI)
		.value("MPOPTION_SHUFFLE_TEAMS", MPOPTION_SHUFFLE_TEAMS)
		.value("MPOPTION_ANONYMOUS", MPOPTION_ANONYMOUS)
		.value("MPOPTION_TURN_TIMER", MPOPTION_TURN_TIMER)
		.value("NUM_MPOPTION_TYPES", NUM_MPOPTION_TYPES)
		;

	python::enum_<SpecialOptionTypes>("SpecialOptionTypes")
		.value("NO_SPECIALOPTION", NO_SPECIALOPTION)
		.value("SPECIALOPTION_REPORT_STATS", SPECIALOPTION_REPORT_STATS)
		.value("NUM_SPECIALOPTION_TYPES", NUM_SPECIALOPTION_TYPES)
		;

	python::enum_<PlayerOptionTypes>("PlayerOptionTypes")
		.value("NO_PLAYEROPTION", NO_PLAYEROPTION)
		.value("PLAYEROPTION_ADVISOR_POPUPS", PLAYEROPTION_ADVISOR_POPUPS)
		.value("PLAYEROPTION_ADVISOR_HELP", PLAYEROPTION_ADVISOR_HELP)
		.value("PLAYEROPTION_WAIT_END_TURN", PLAYEROPTION_WAIT_END_TURN)
		.value("PLAYEROPTION_MINIMIZE_POP_UPS", PLAYEROPTION_MINIMIZE_POP_UPS)
		.value("PLAYEROPTION_SHOW_FRIENDLY_MOVES", PLAYEROPTION_SHOW_FRIENDLY_MOVES)
		.value("PLAYEROPTION_SHOW_ENEMY_MOVES", PLAYEROPTION_SHOW_ENEMY_MOVES)
		.value("PLAYEROPTION_QUICK_MOVES", PLAYEROPTION_QUICK_MOVES)
		.value("PLAYEROPTION_QUICK_ATTACK", PLAYEROPTION_QUICK_ATTACK)
		.value("PLAYEROPTION_QUICK_DEFENSE", PLAYEROPTION_QUICK_DEFENSE)
		.value("PLAYEROPTION_STACK_ATTACK", PLAYEROPTION_STACK_ATTACK)
		.value("PLAYEROPTION_AUTO_PROMOTION", PLAYEROPTION_AUTO_PROMOTION)
		.value("PLAYEROPTION_START_AUTOMATED", PLAYEROPTION_START_AUTOMATED)
		.value("PLAYEROPTION_SAFE_AUTOMATION", PLAYEROPTION_SAFE_AUTOMATION)
		.value("PLAYEROPTION_NUMPAD_HELP", PLAYEROPTION_NUMPAD_HELP)
		.value("PLAYEROPTION_NO_UNIT_CYCLING", PLAYEROPTION_NO_UNIT_CYCLING)
		.value("PLAYEROPTION_NO_UNIT_RECOMMENDATIONS", PLAYEROPTION_NO_UNIT_RECOMMENDATIONS)
		.value("PLAYEROPTION_RIGHT_CLICK_MENU", PLAYEROPTION_RIGHT_CLICK_MENU)
		.value("PLAYEROPTION_LEAVE_FORESTS", PLAYEROPTION_LEAVE_FORESTS)
		.value("PLAYEROPTION_MISSIONARIES_AUTOMATED", PLAYEROPTION_MISSIONARIES_AUTOMATED)
		.value("PLAYEROPTION_MODDER_1", PLAYEROPTION_MODDER_1)
		.value("PLAYEROPTION_MODDER_2", PLAYEROPTION_MODDER_2)
		.value("PLAYEROPTION_MODDER_3", PLAYEROPTION_MODDER_3)
		.value("NUM_PLAYEROPTION_TYPES", NUM_PLAYEROPTION_TYPES)
		;

	python::enum_<GraphicOptionTypes>("GraphicOptionTypes")
		.value("NO_GRAPHICOPTION", NO_GRAPHICOPTION)
		.value("GRAPHICOPTION_SINGLE_UNIT_GRAPHICS", GRAPHICOPTION_SINGLE_UNIT_GRAPHICS)
		.value("GRAPHICOPTION_HEALTH_BARS", GRAPHICOPTION_HEALTH_BARS)
		.value("GRAPHICOPTION_CITY_DETAIL", GRAPHICOPTION_CITY_DETAIL)
		.value("GRAPHICOPTION_NO_COMBAT_ZOOM", GRAPHICOPTION_NO_COMBAT_ZOOM)
		.value("GRAPHICOPTION_NO_ENEMY_GLOW", GRAPHICOPTION_NO_ENEMY_GLOW)
		.value("GRAPHICOPTION_FROZEN_ANIMATIONS", GRAPHICOPTION_FROZEN_ANIMATIONS)
		.value("GRAPHICOPTION_EFFECTS_DISABLED", GRAPHICOPTION_EFFECTS_DISABLED)
		.value("GRAPHICOPTION_GLOBE_VIEW_BUILDINGS_DISABLED", GRAPHICOPTION_GLOBE_VIEW_BUILDINGS_DISABLED)
		.value("GRAPHICOPTION_FULLSCREEN", GRAPHICOPTION_FULLSCREEN)
		.value("GRAPHICOPTION_LOWRES_TEXTURES", GRAPHICOPTION_LOWRES_TEXTURES)
		.value("GRAPHICOPTION_HIRES_TERRAIN", GRAPHICOPTION_HIRES_TERRAIN)
		.value("GRAPHICOPTION_NO_MOVIES", GRAPHICOPTION_NO_MOVIES)
		.value("GRAPHICOPTION_CITY_RADIUS", GRAPHICOPTION_CITY_RADIUS)
		.value("NUM_GRAPHICOPTION_TYPES", NUM_GRAPHICOPTION_TYPES)
		;

	python::enum_<ForceControlTypes>("ForceControlTypes")
		.value("NO_FORCECONTROL", NO_FORCECONTROL)
		.value("FORCECONTROL_SPEED", FORCECONTROL_SPEED)
		.value("FORCECONTROL_HANDICAP", FORCECONTROL_HANDICAP)
		.value("FORCECONTROL_OPTIONS", FORCECONTROL_OPTIONS)
		.value("FORCECONTROL_VICTORIES", FORCECONTROL_VICTORIES)
		.value("FORCECONTROL_MAX_TURNS", FORCECONTROL_MAX_TURNS)
		.value("FORCECONTROL_MAX_CITY_ELIMINATIONS", FORCECONTROL_MAX_CITY_ELIMINATION)
		.value("FORCECONTROL_ADVANCED_START", FORCECONTROL_ADVANCED_START)
		.value("NUM_FORCECONTROL_TYPES", NUM_FORCECONTROL_TYPES)
		;

	python::enum_<VictoryTypes>("VictoryTypes")
		.value("NO_VICTORY", NO_VICTORY)
		;

	python::enum_<FeatureTypes>("FeatureTypes")
		.value("NO_FEATURE", NO_FEATURE)
		;

	python::enum_<BonusTypes>("BonusTypes")
		.value("NO_BONUS", NO_BONUS)
		;

	python::enum_<BonusClassTypes>("BonusClassTypes")
		.value("NO_BONUSCLASS", NO_BONUSCLASS)
		;

	python::enum_<ImprovementTypes>("ImprovementTypes")
		.value("NO_IMPROVEMENT", NO_IMPROVEMENT)
		;

	python::enum_<RouteTypes>("RouteTypes")
		.value("NO_ROUTE", NO_ROUTE)
		;

	python::enum_<RiverTypes>("RiverTypes")
		.value("NO_RIVER", NO_RIVER)
		;

	python::enum_<GoodyTypes>("GoodyTypes")
		.value("NO_GOODY", NO_GOODY)
		;

	python::enum_<BuildTypes>("BuildTypes")
		.value("NO_BUILD", NO_BUILD)
		;

	python::enum_<SymbolTypes>("SymbolTypes")
		.value("NO_SYMBOL", NO_SYMBOL)
		;

	python::enum_<FontSymbols>("FontSymbols")
		.value("HAPPY_CHAR", HAPPY_CHAR)
		.value("UNHAPPY_CHAR", UNHAPPY_CHAR)
		.value("HEALTHY_CHAR", HEALTHY_CHAR)
		.value("UNHEALTHY_CHAR", UNHEALTHY_CHAR)
		.value("BULLET_CHAR", BULLET_CHAR)
		.value("STRENGTH_CHAR", STRENGTH_CHAR)
		.value("MOVES_CHAR", MOVES_CHAR)
		.value("RELIGION_CHAR", RELIGION_CHAR)
		.value("STAR_CHAR", STAR_CHAR)
		.value("SILVER_STAR_CHAR", SILVER_STAR_CHAR)
		.value("TRADE_CHAR", TRADE_CHAR)
		.value("DEFENSE_CHAR", DEFENSE_CHAR)
		.value("GREAT_PEOPLE_CHAR", GREAT_PEOPLE_CHAR)
		.value("BAD_GOLD_CHAR", BAD_GOLD_CHAR)
		.value("BAD_FOOD_CHAR", BAD_FOOD_CHAR)
		.value("EATEN_FOOD_CHAR", EATEN_FOOD_CHAR)
		.value("GOLDEN_AGE_CHAR", GOLDEN_AGE_CHAR)
		.value("ANGRY_POP_CHAR", ANGRY_POP_CHAR)
		.value("OPEN_BORDERS_CHAR", OPEN_BORDERS_CHAR)
		.value("DEFENSIVE_PACT_CHAR", DEFENSIVE_PACT_CHAR)
		.value("MAP_CHAR", MAP_CHAR)
		.value("OCCUPATION_CHAR", OCCUPATION_CHAR)
		.value("POWER_CHAR", POWER_CHAR)
		//Kathy beginn Housing
		.value("HOUSING_CHAR", HOUSING_CHAR)
		//Kathy end Housing
		.value("MAX_NUM_SYMBOLS", MAX_NUM_SYMBOLS)
		;

	python::enum_<HandicapTypes>("HandicapTypes")
		.value("NO_HANDICAP", NO_HANDICAP)
		;

	python::enum_<GameSpeedTypes>("GameSpeedTypes")
		.value("NO_GAMESPEED", NO_GAMESPEED)
		;

	python::enum_<TurnTimerTypes>("TurnTimerTypes")
		.value("NO_TURNTIMER", NO_TURNTIMER)
		;

	python::enum_<EraTypes>("EraTypes")
		.value("NO_ERA", NO_ERA)
		;

	python::enum_<CivilizationTypes>("CivilizationTypes")
		.value("NO_CIVILIZATION", NO_CIVILIZATION)
		;

	python::enum_<LeaderHeadTypes>("LeaderHeadTypes")
		.value("NO_LEADER", NO_LEADER)
		;

	python::enum_<ArtStyleTypes>("ArtStyleTypes")
		.value("NO_ARTSTYLE", NO_ARTSTYLE)
		;

	python::enum_<CitySizeTypes>("CitySizeTypes")
		.value("NO_CITYSIZE", NO_CITYSIZE)
		.value("CITYSIZE_SMALL", CITYSIZE_SMALL)
		.value("CITYSIZE_MEDIUM", CITYSIZE_MEDIUM)
		.value("CITYSIZE_LARGE", CITYSIZE_LARGE)
		.value("NUM_CITYSIZE_TYPES", NUM_CITYSIZE_TYPES)
		;

	python::enum_<FootstepAudioTypes>("FootstepAudioTypes")
		.value("NO_FOOTSTEPAUDIO", NO_FOOTSTEPAUDIO)
		;

	python::enum_<FootstepAudioTags>("FootstepAudioTags")
		.value("NO_FOOTSTEPAUDIO_TAG", NO_FOOTSTEPAUDIO_TAG)
		;

	python::enum_<ChatTargetTypes>("ChatTargetTypes")
		.value("NO_CHATTARGET", NO_CHATTARGET)
		.value("CHATTARGET_ALL", CHATTARGET_ALL)
		.value("CHATTARGET_TEAM", CHATTARGET_TEAM)
		;

	python::enum_<VoiceTargetTypes>("VoiceTargetTypes")
		.value("NO_VOICETARGET", NO_VOICETARGET)
		.value("VOICETARGET_DIPLO", VOICETARGET_DIPLO)
		.value("VOICETARGET_TEAM", VOICETARGET_TEAM)
		.value("VOICETARGET_ALL", VOICETARGET_ALL)
		.value("NUM_VOICETARGETS", NUM_VOICETARGETS)
		;

	python::enum_<TeamTypes>("TeamTypes")
		.value("NO_TEAM", NO_TEAM)
		;

	python::enum_<PlayerTypes>("PlayerTypes")
		.value("NO_PLAYER", NO_PLAYER)
		;

	python::enum_<TraitTypes>("TraitTypes")
		.value("NO_TRAIT", NO_TRAIT)
		;

	python::enum_<OrderTypes>("OrderTypes")
		.value("NO_ORDER", NO_ORDER)
		.value("ORDER_TRAIN", ORDER_TRAIN)
		.value("ORDER_CONSTRUCT", ORDER_CONSTRUCT)
		.value("ORDER_CREATE", ORDER_CREATE)
		.value("ORDER_MAINTAIN", ORDER_MAINTAIN)
		.value("NUM_ORDER_TYPES", NUM_ORDER_TYPES)
		;

	python::enum_<TaskTypes>("TaskTypes")
		.value("TASK_RAZE", TASK_RAZE)
		.value("TASK_DISBAND", TASK_DISBAND)
		.value("TASK_GIFT", TASK_GIFT)
		.value("TASK_SET_AUTOMATED_CITIZENS", TASK_SET_AUTOMATED_CITIZENS)
		.value("TASK_SET_AUTOMATED_PRODUCTION", TASK_SET_AUTOMATED_PRODUCTION)
		.value("TASK_SET_EMPHASIZE", TASK_SET_EMPHASIZE)
		.value("TASK_CHANGE_SPECIALIST", TASK_CHANGE_SPECIALIST)
		.value("TASK_CHANGE_WORKING_PLOT", TASK_CHANGE_WORKING_PLOT)
		.value("TASK_CLEAR_WORKING_OVERRIDE", TASK_CLEAR_WORKING_OVERRIDE)
		.value("TASK_HURRY", TASK_HURRY)
		.value("TASK_CONSCRIPT", TASK_HURRY)
		.value("TASK_CLEAR_ORDERS", TASK_CLEAR_ORDERS)
		.value("TASK_RALLY_PLOT", TASK_RALLY_PLOT)
		.value("TASK_CLEAR_RALLY_PLOT", TASK_CLEAR_RALLY_PLOT)
		.value("TASK_LIBERATE", TASK_LIBERATE)
		.value("NUM_TASK_TYPES", NUM_TASK_TYPES)
		;

	python::enum_<BuildingClassTypes>("BuildingClassTypes")
		.value("NO_BUILDINGCLASS", NO_BUILDINGCLASS)
		;

	python::enum_<BuildingTypes>("BuildingTypes")
		.value("NO_BUILDING", NO_BUILDING)
		;

	python::enum_<SpecialBuildingTypes>("SpecialBuildingTypes")
		.value("NO_SPECIALBUILDING", NO_SPECIALBUILDING)
		;

	python::enum_<ProjectTypes>("ProjectTypes")
		.value("NO_PROJECT", NO_PROJECT)
		;

	python::enum_<ProcessTypes>("ProcessTypes")
		.value("NO_PROCESS", NO_PROCESS)
		;

	python::enum_<VoteTypes>("VoteTypes")
		.value("NO_VOTE", NO_VOTE)
		;

	python::enum_<PlayerVoteTypes>("PlayerVoteTypes")
		.value("NO_PLAYER_VOTE_CHECKED", NO_PLAYER_VOTE_CHECKED)
		.value("PLAYER_VOTE_NEVER", PLAYER_VOTE_NEVER)
		.value("PLAYER_VOTE_ABSTAIN", PLAYER_VOTE_ABSTAIN)
		.value("PLAYER_VOTE_NO", PLAYER_VOTE_NO)
		.value("PLAYER_VOTE_YES", PLAYER_VOTE_YES)
		.value("NO_PLAYER_VOTE", NO_PLAYER_VOTE)
		;

	python::enum_<InfoBarTypes>("InfoBarTypes")
		.value("INFOBAR_STORED", INFOBAR_STORED)
		.value("INFOBAR_RATE", INFOBAR_RATE)
		.value("INFOBAR_RATE_EXTRA", INFOBAR_RATE_EXTRA)
		.value("INFOBAR_EMPTY", INFOBAR_EMPTY)
		.value("NUM_INFOBAR_TYPES", NUM_INFOBAR_TYPES)
		;

	python::enum_<HealthBarTypes>("HealthBarTypes")
		.value("HEALTHBAR_ALIVE_ATTACK", HEALTHBAR_ALIVE_ATTACK)
		.value("HEALTHBAR_ALIVE_DEFEND", HEALTHBAR_ALIVE_DEFEND)
		.value("HEALTHBAR_DEAD", HEALTHBAR_DEAD)
		.value("NUM_HEALTHBAR_TYPES", NUM_HEALTHBAR_TYPES)
		;

	python::enum_<ConceptTypes>("ConceptTypes")
		.value("NO_CONCEPT", NO_CONCEPT)
		;

	python::enum_<NewConceptTypes>("NewConceptTypes")
		.value("NO_NEW_CONCEPT", NO_NEW_CONCEPT)
		;

	python::enum_<CalendarTypes>("CalendarTypes")
		.value("CALENDAR_DEFAULT", CALENDAR_DEFAULT)
		.value("CALENDAR_BI_YEARLY", CALENDAR_BI_YEARLY)
		.value("CALENDAR_YEARS", CALENDAR_YEARS)
		.value("CALENDAR_TURNS", CALENDAR_TURNS)
		.value("CALENDAR_SEASONS", CALENDAR_SEASONS)
		.value("CALENDAR_MONTHS", CALENDAR_MONTHS)
		.value("CALENDAR_WEEKS", CALENDAR_WEEKS)
		;

	python::enum_<SeasonTypes>("SeasonTypes")
		.value("NO_SEASON", NO_SEASON)
		;

	python::enum_<MonthTypes>("MonthTypes")
		.value("NO_MONTH", NO_MONTH)
		;

	python::enum_<DenialTypes>("DenialTypes")
		.value("NO_DENIAL", NO_DENIAL)
		.value("DENIAL_UNKNOWN", DENIAL_UNKNOWN)
		.value("DENIAL_NEVER", DENIAL_NEVER)
		.value("DENIAL_TOO_MUCH", DENIAL_TOO_MUCH)
		.value("DENIAL_MYSTERY", DENIAL_MYSTERY)
		.value("DENIAL_JOKING", DENIAL_JOKING)
		.value("DENIAL_ANGER_CIVIC", DENIAL_ANGER_CIVIC)
		.value("DENIAL_FAVORITE_CIVIC", DENIAL_FAVORITE_CIVIC)
		.value("DENIAL_MINORITY_RELIGION", DENIAL_MINORITY_RELIGION)
		.value("DENIAL_CONTACT_THEM", DENIAL_CONTACT_THEM)
		.value("DENIAL_VICTORY", DENIAL_VICTORY)
		.value("DENIAL_ATTITUDE", DENIAL_ATTITUDE)
		.value("DENIAL_ATTITUDE_THEM", DENIAL_ATTITUDE_THEM)
		.value("DENIAL_TECH_WHORE", DENIAL_TECH_WHORE)
		.value("DENIAL_TECH_MONOPOLY", DENIAL_TECH_MONOPOLY)
		.value("DENIAL_POWER_US", DENIAL_POWER_US)
		.value("DENIAL_POWER_YOU", DENIAL_POWER_YOU)
		.value("DENIAL_POWER_THEM", DENIAL_POWER_THEM)
		.value("DENIAL_TOO_MANY_WARS", DENIAL_TOO_MANY_WARS)
		.value("DENIAL_NO_GAIN", DENIAL_NO_GAIN)
		.value("DENIAL_NOT_ALLIED", DENIAL_NOT_ALLIED)
		.value("DENIAL_RECENT_CANCEL", DENIAL_RECENT_CANCEL)
		.value("DENIAL_WORST_ENEMY", DENIAL_WORST_ENEMY)
		.value("DENIAL_POWER_YOUR_ENEMIES", DENIAL_POWER_YOUR_ENEMIES)
		.value("DENIAL_TOO_FAR", DENIAL_TOO_FAR)
		;

	python::enum_<DomainTypes>("DomainTypes")
		.value("DOMAIN_SEA", DOMAIN_SEA)
		.value("DOMAIN_AIR", DOMAIN_AIR)
		.value("DOMAIN_LAND", DOMAIN_LAND)
		.value("DOMAIN_IMMOBILE", DOMAIN_IMMOBILE)
		.value("NUM_DOMAIN_TYPES", NUM_DOMAIN_TYPES)
		;

	python::enum_<UnitClassTypes>("UnitClassTypes")
		.value("NO_UNITCLASS", NO_UNITCLASS)
		;

	python::enum_<UnitTypes>("UnitTypes")
		.value("NO_UNIT", NO_UNIT)
		;

	python::enum_<SpecialUnitTypes>("SpecialUnitTypes")
		.value("NO_SPECIALUNIT", NO_SPECIALUNIT)
		;

	python::enum_<UnitCombatTypes>("UnitCombatTypes")
		.value("NO_UNITCOMBAT", NO_UNITCOMBAT)
		;

	python::enum_<UnitAITypes>("UnitAITypes")
		.value("NO_UNITAI", NO_UNITAI)
		.value("UNITAI_UNKNOWN", UNITAI_UNKNOWN)
		.value("UNITAI_ANIMAL", UNITAI_ANIMAL)
		.value("UNITAI_SETTLE", UNITAI_SETTLE)
		.value("UNITAI_WORKER", UNITAI_WORKER)
		.value("UNITAI_ATTACK", UNITAI_ATTACK)
		.value("UNITAI_ATTACK_CITY", UNITAI_ATTACK_CITY)
		.value("UNITAI_COLLATERAL", UNITAI_COLLATERAL)
		.value("UNITAI_PILLAGE", UNITAI_PILLAGE)
		.value("UNITAI_RESERVE", UNITAI_RESERVE)
		.value("UNITAI_COUNTER", UNITAI_COUNTER)
		.value("UNITAI_CITY_DEFENSE", UNITAI_CITY_DEFENSE)
		.value("UNITAI_CITY_COUNTER", UNITAI_CITY_COUNTER)
		.value("UNITAI_CITY_SPECIAL", UNITAI_CITY_SPECIAL)
		.value("UNITAI_EXPLORE", UNITAI_EXPLORE)
		.value("UNITAI_MISSIONARY", UNITAI_MISSIONARY)
		.value("UNITAI_PROPHET", UNITAI_PROPHET)
		.value("UNITAI_ARTIST", UNITAI_ARTIST)
		.value("UNITAI_SCIENTIST", UNITAI_SCIENTIST)
		.value("UNITAI_GENERAL", UNITAI_GENERAL)
		.value("UNITAI_MERCHANT", UNITAI_MERCHANT)
		.value("UNITAI_ENGINEER", UNITAI_ENGINEER)
		.value("UNITAI_SPY", UNITAI_SPY)
		.value("UNITAI_ICBM", UNITAI_ICBM)
		.value("UNITAI_WORKER_SEA", UNITAI_WORKER_SEA)
		.value("UNITAI_ATTACK_SEA", UNITAI_ATTACK_SEA)
		.value("UNITAI_RESERVE_SEA", UNITAI_RESERVE_SEA)
		.value("UNITAI_ESCORT_SEA", UNITAI_ESCORT_SEA)
		.value("UNITAI_EXPLORE_SEA", UNITAI_EXPLORE_SEA)
		.value("UNITAI_ASSAULT_SEA", UNITAI_ASSAULT_SEA)
		.value("UNITAI_SETTLER_SEA", UNITAI_SETTLER_SEA)
		.value("UNITAI_MISSIONARY_SEA", UNITAI_MISSIONARY_SEA)
		.value("UNITAI_SPY_SEA", UNITAI_SPY_SEA)
		.value("UNITAI_CARRIER_SEA", UNITAI_CARRIER_SEA)
		.value("UNITAI_MISSILE_CARRIER_SEA", UNITAI_MISSILE_CARRIER_SEA)
		.value("UNITAI_PIRATE_SEA", UNITAI_PIRATE_SEA)
		.value("UNITAI_ATTACK_AIR", UNITAI_ATTACK_AIR)
		.value("UNITAI_DEFENSE_AIR", UNITAI_DEFENSE_AIR)
		.value("UNITAI_CARRIER_AIR", UNITAI_CARRIER_AIR)
		.value("UNITAI_MISSILE_AIR", UNITAI_MISSILE_AIR)
		.value("UNITAI_PARADROP", UNITAI_PARADROP)
		.value("UNITAI_ATTACK_CITY_LEMMING", UNITAI_ATTACK_CITY_LEMMING)
		.value("UNITAI_RANGED_ATTACK", UNITAI_RANGED_ATTACK)
		.value("NUM_UNITAI_TYPES", NUM_UNITAI_TYPES)
		;

	python::enum_<InvisibleTypes>("InvisibleTypes")
		.value("NO_INVISIBLE", NO_INVISIBLE)
		;

	python::enum_<VoteSourceTypes>("VoteSourceTypes")
		.value("NO_VOTESOURCE", NO_VOTESOURCE)
		;

	python::enum_<ProbabilityTypes>("ProbabilityTypes")
		.value("NO_PROBABILITY", NO_PROBABILITY)
		.value("PROBABILITY_LOW", PROBABILITY_LOW)
		.value("PROBABILITY_REAL", PROBABILITY_REAL)
		.value("PROBABILITY_HIGH", PROBABILITY_HIGH)
		;

	python::enum_<ActivityTypes>("ActivityTypes")
		.value("NO_ACTIVITY", NO_ACTIVITY)
		.value("ACTIVITY_AWAKE", ACTIVITY_AWAKE)
		.value("ACTIVITY_HOLD", ACTIVITY_HOLD)
		.value("ACTIVITY_SLEEP", ACTIVITY_SLEEP)
		.value("ACTIVITY_HEAL", ACTIVITY_HEAL)
		.value("ACTIVITY_SENTRY", ACTIVITY_SENTRY)
		.value("ACTIVITY_INTERCEPT", ACTIVITY_INTERCEPT)
		.value("ACTIVITY_MISSION", ACTIVITY_MISSION)
		.value("ACTIVITY_PATROL", ACTIVITY_PATROL)
		.value("ACTIVITY_PLUNDER", ACTIVITY_PLUNDER)
		.value("NUM_ACTIVITY_TYPES", NUM_ACTIVITY_TYPES)
		;

	python::enum_<AutomateTypes>("AutomateTypes")
		.value("NO_AUTOMATE", NO_AUTOMATE)
		.value("AUTOMATE_BUILD", AUTOMATE_BUILD)
		.value("AUTOMATE_NETWORK", AUTOMATE_NETWORK)
		.value("AUTOMATE_CITY", AUTOMATE_CITY)
		.value("AUTOMATE_EXPLORE", AUTOMATE_EXPLORE)
		.value("AUTOMATE_RELIGION", AUTOMATE_RELIGION)
/************************************************************************************************/
/* Afforess/RevDCM            Start		 09/16/10                                               */
/*                                                                                              */
/* Advanced Automations                                                                         */
/************************************************************************************************/
		.value("AUTOMATE_ESPIONAGE", AUTOMATE_ESPIONAGE)
/************************************************************************************************/
/* Afforess/RevDCM               END                                                            */
/************************************************************************************************/
		.value("NUM_AUTOMATE_TYPES", NUM_AUTOMATE_TYPES)
		;

	python::enum_<MissionTypes>("MissionTypes")
		.value("NO_MISSION", NO_MISSION)
		.value("MISSION_MOVE_TO", MISSION_MOVE_TO)
		.value("MISSION_ROUTE_TO", MISSION_ROUTE_TO)
		.value("MISSION_MOVE_TO_UNIT", MISSION_MOVE_TO_UNIT)
		.value("MISSION_SKIP", MISSION_SKIP)
		.value("MISSION_SLEEP", MISSION_SLEEP)
		.value("MISSION_FORTIFY", MISSION_FORTIFY)
		.value("MISSION_PLUNDER", MISSION_PLUNDER)
		.value("MISSION_AIRPATROL", MISSION_AIRPATROL)
		.value("MISSION_SEAPATROL", MISSION_SEAPATROL)
		.value("MISSION_HEAL", MISSION_HEAL)
		.value("MISSION_SENTRY", MISSION_SENTRY)
		.value("MISSION_AIRLIFT", MISSION_AIRLIFT)
		.value("MISSION_NUKE", MISSION_NUKE)
		.value("MISSION_RECON", MISSION_RECON)
		.value("MISSION_PARADROP", MISSION_PARADROP)
		.value("MISSION_AIRBOMB", MISSION_AIRBOMB)
		.value("MISSION_RANGE_ATTACK", MISSION_RANGE_ATTACK)
		.value("MISSION_BOMBARD", MISSION_BOMBARD)
		.value("MISSION_PILLAGE", MISSION_PILLAGE)
		.value("MISSION_SABOTAGE", MISSION_SABOTAGE)
		.value("MISSION_DESTROY", MISSION_DESTROY)
		.value("MISSION_STEAL_PLANS", MISSION_STEAL_PLANS)
		.value("MISSION_FOUND", MISSION_FOUND)
		.value("MISSION_SPREAD", MISSION_SPREAD)
		.value("MISSION_SPREAD_CORPORATION", MISSION_SPREAD_CORPORATION)
		.value("MISSION_JOIN", MISSION_JOIN)
		.value("MISSION_CONSTRUCT", MISSION_CONSTRUCT)
		.value("MISSION_DISCOVER", MISSION_DISCOVER)
		.value("MISSION_HURRY", MISSION_HURRY)
		.value("MISSION_TRADE", MISSION_TRADE)
		.value("MISSION_GREAT_WORK", MISSION_GREAT_WORK)
		.value("MISSION_INFILTRATE", MISSION_INFILTRATE)
		.value("MISSION_LEAD", MISSION_LEAD)
		.value("MISSION_ESPIONAGE", MISSION_ESPIONAGE)
		.value("MISSION_GOLDEN_AGE", MISSION_GOLDEN_AGE)
		.value("MISSION_BUILD", MISSION_BUILD)
		.value("MISSION_BEGIN_COMBAT", MISSION_BEGIN_COMBAT )
		.value("MISSION_END_COMBAT", MISSION_END_COMBAT )
		.value("MISSION_AIRSTRIKE", MISSION_AIRSTRIKE )
		.value("MISSION_SURRENDER", MISSION_SURRENDER )
		.value("MISSION_CAPTURED", MISSION_CAPTURED )
		.value("MISSION_IDLE", MISSION_IDLE )
		.value("MISSION_DIE", MISSION_DIE )
		.value("MISSION_DAMAGE", MISSION_DAMAGE )
		.value("MISSION_MULTI_SELECT", MISSION_MULTI_SELECT )
		.value("MISSION_MULTI_DESELECT", MISSION_MULTI_DESELECT )
/************************************************************************************************/
/* Afforess	                  Start		 09/19/10                                               */
/*                                                                                              */
/* Advanced Automations                                                                         */
/************************************************************************************************/
		.value("MISSION_ESPIONAGE_SLEEP", MISSION_ESPIONAGE_SLEEP)
/************************************************************************************************/
/* Afforess	                     END                                                            */
/************************************************************************************************/
		.value("MISSION_AIRBOMB1", MISSION_AIRBOMB1)
		.value("MISSION_AIRBOMB2", MISSION_AIRBOMB2)
		.value("MISSION_AIRBOMB3", MISSION_AIRBOMB3)
		.value("MISSION_AIRBOMB4", MISSION_AIRBOMB4)
		.value("MISSION_AIRBOMB5", MISSION_AIRBOMB5)
		.value("NUM_MISSION_TYPES", NUM_MISSION_TYPES )
		;

	python::enum_<MissionAITypes>("MissionAITypes")
		.value("NO_MISSIONAI", NO_MISSIONAI)
		.value("MISSIONAI_SHADOW", MISSIONAI_SHADOW)
		.value("MISSIONAI_GROUP", MISSIONAI_GROUP)
		.value("MISSIONAI_LOAD_ASSAULT", MISSIONAI_LOAD_ASSAULT)
		.value("MISSIONAI_LOAD_SETTLER", MISSIONAI_LOAD_SETTLER)
		.value("MISSIONAI_LOAD_SPECIAL", MISSIONAI_LOAD_SPECIAL)
		.value("MISSIONAI_GUARD_CITY", MISSIONAI_GUARD_CITY)
		.value("MISSIONAI_GUARD_BONUS", MISSIONAI_GUARD_BONUS)
		.value("MISSIONAI_GUARD_TRADE_NET", MISSIONAI_GUARD_TRADE_NET)
		.value("MISSIONAI_GUARD_SPY", MISSIONAI_GUARD_SPY)
		.value("MISSIONAI_ATTACK_SPY", MISSIONAI_ATTACK_SPY)
		.value("MISSIONAI_SPREAD", MISSIONAI_SPREAD)
		.value("MISSIONAI_SPREAD_CORPORATION", MISSIONAI_SPREAD_CORPORATION)
		.value("MISSIONAI_CONSTRUCT", MISSIONAI_CONSTRUCT)
		.value("MISSIONAI_HURRY", MISSIONAI_HURRY)
		.value("MISSIONAI_GREAT_WORK", MISSIONAI_GREAT_WORK)
		.value("MISSIONAI_EXPLORE", MISSIONAI_EXPLORE)
		.value("MISSIONAI_BLOCKADE", MISSIONAI_BLOCKADE)
		.value("MISSIONAI_PILLAGE", MISSIONAI_PILLAGE)
		.value("MISSIONAI_FOUND", MISSIONAI_FOUND)
		.value("MISSIONAI_BUILD", MISSIONAI_BUILD)
		.value("MISSIONAI_ASSAULT", MISSIONAI_ASSAULT)
		.value("MISSIONAI_CARRIER", MISSIONAI_CARRIER)
		.value("MISSIONAI_PICKUP", MISSIONAI_PICKUP)
		;

	// any additions need to be reflected in GlobalTypes.xml
	python::enum_<CommandTypes>("CommandTypes")
		.value("NO_COMMAND", NO_COMMAND)
		.value("COMMAND_PROMOTION", COMMAND_PROMOTION)
		.value("COMMAND_UPGRADE", COMMAND_UPGRADE)
		.value("COMMAND_AUTOMATE", COMMAND_AUTOMATE)
		.value("COMMAND_WAKE", COMMAND_WAKE)
		.value("COMMAND_CANCEL", COMMAND_CANCEL)
		.value("COMMAND_CANCEL_ALL", COMMAND_CANCEL_ALL)
		.value("COMMAND_STOP_AUTOMATION", COMMAND_STOP_AUTOMATION)
		.value("COMMAND_DELETE", COMMAND_DELETE)
		.value("COMMAND_GIFT", COMMAND_GIFT)
		.value("COMMAND_LOAD", COMMAND_LOAD)
		.value("COMMAND_LOAD_UNIT", COMMAND_LOAD_UNIT)
		.value("COMMAND_UNLOAD", COMMAND_UNLOAD)
		.value("COMMAND_UNLOAD_ALL", COMMAND_UNLOAD_ALL)
		.value("COMMAND_HOTKEY", COMMAND_HOTKEY)
		.value("NUM_COMMAND_TYPES", NUM_COMMAND_TYPES)
		;

	python::enum_<ControlTypes>("ControlTypes")
		.value("NO_CONTROL", NO_CONTROL)
		.value("CONTROL_CENTERONSELECTION", CONTROL_CENTERONSELECTION)
		.value("CONTROL_SELECTYUNITTYPE", CONTROL_SELECTYUNITTYPE)
		.value("CONTROL_SELECTYUNITALL", CONTROL_SELECTYUNITALL)
		.value("CONTROL_SELECTCITY", CONTROL_SELECTCITY)
		.value("CONTROL_SELECTCAPITAL", CONTROL_SELECTCAPITAL)
		.value("CONTROL_NEXTCITY", CONTROL_NEXTCITY)
		.value("CONTROL_PREVCITY", CONTROL_PREVCITY)
		.value("CONTROL_NEXTUNIT", CONTROL_NEXTUNIT)
		.value("CONTROL_PREVUNIT", CONTROL_PREVUNIT)
		.value("CONTROL_CYCLEUNIT", CONTROL_CYCLEUNIT)
		.value("CONTROL_CYCLEUNIT_ALT", CONTROL_CYCLEUNIT_ALT)
		.value("CONTROL_CYCLEWORKER", CONTROL_CYCLEWORKER)
		.value("CONTROL_LASTUNIT", CONTROL_LASTUNIT)
		.value("CONTROL_ENDTURN", CONTROL_ENDTURN)
		.value("CONTROL_ENDTURN_ALT", CONTROL_ENDTURN_ALT)
		.value("CONTROL_FORCEENDTURN", CONTROL_FORCEENDTURN)
		.value("CONTROL_AUTOMOVES", CONTROL_AUTOMOVES)
		.value("CONTROL_PING", CONTROL_PING)
		.value("CONTROL_SIGN", CONTROL_SIGN)
		.value("CONTROL_GRID", CONTROL_GRID)
		.value("CONTROL_BARE_MAP", CONTROL_BARE_MAP)
		.value("CONTROL_YIELDS", CONTROL_YIELDS)
		.value("CONTROL_RESOURCE_ALL", CONTROL_RESOURCE_ALL)
		.value("CONTROL_UNIT_ICONS", CONTROL_UNIT_ICONS)
		.value("CONTROL_GLOBELAYER", CONTROL_GLOBELAYER)
		.value("CONTROL_SCORES", CONTROL_SCORES)
		.value("CONTROL_LOAD_GAME", CONTROL_LOAD_GAME)
		.value("CONTROL_OPTIONS_SCREEN", CONTROL_OPTIONS_SCREEN)
		.value("CONTROL_RETIRE", CONTROL_RETIRE)
		.value("CONTROL_SAVE_GROUP", CONTROL_SAVE_GROUP)
		.value("CONTROL_SAVE_NORMAL", CONTROL_SAVE_NORMAL)
		.value("CONTROL_QUICK_SAVE", CONTROL_QUICK_SAVE)
		.value("CONTROL_QUICK_LOAD", CONTROL_QUICK_LOAD)
		.value("CONTROL_ORTHO_CAMERA", CONTROL_ORTHO_CAMERA)
		.value("CONTROL_CYCLE_CAMERA_FLYING_MODES", CONTROL_CYCLE_CAMERA_FLYING_MODES)
		.value("CONTROL_ISOMETRIC_CAMERA_LEFT", CONTROL_ISOMETRIC_CAMERA_LEFT)
		.value("CONTROL_ISOMETRIC_CAMERA_RIGHT", CONTROL_ISOMETRIC_CAMERA_RIGHT)
		.value("CONTROL_FLYING_CAMERA", CONTROL_FLYING_CAMERA)
		.value("CONTROL_MOUSE_FLYING_CAMERA", CONTROL_MOUSE_FLYING_CAMERA)
		.value("CONTROL_TOP_DOWN_CAMERA", CONTROL_TOP_DOWN_CAMERA)
		.value("CONTROL_CIVILOPEDIA", CONTROL_CIVILOPEDIA)
		.value("CONTROL_RELIGION_SCREEN", CONTROL_RELIGION_SCREEN)
		.value("CONTROL_CORPORATION_SCREEN", CONTROL_CORPORATION_SCREEN)
		.value("CONTROL_CIVICS_SCREEN", CONTROL_CIVICS_SCREEN)
		.value("CONTROL_FOREIGN_SCREEN", CONTROL_FOREIGN_SCREEN)
		.value("CONTROL_FINANCIAL_SCREEN", CONTROL_FINANCIAL_SCREEN)
		.value("CONTROL_MILITARY_SCREEN", CONTROL_MILITARY_SCREEN)
		.value("CONTROL_TECH_CHOOSER", CONTROL_TECH_CHOOSER)
		.value("CONTROL_TURN_LOG", CONTROL_TURN_LOG)
		.value("CONTROL_CHAT_ALL", CONTROL_CHAT_ALL)
		.value("CONTROL_CHAT_TEAM", CONTROL_CHAT_TEAM)
		.value("CONTROL_DOMESTIC_SCREEN", CONTROL_DOMESTIC_SCREEN)
		.value("CONTROL_VICTORY_SCREEN", CONTROL_VICTORY_SCREEN)
		.value("CONTROL_INFO", CONTROL_INFO)
		.value("CONTROL_GLOBE_VIEW", CONTROL_GLOBE_VIEW)
		.value("CONTROL_DETAILS", CONTROL_DETAILS)
		.value("CONTROL_ADMIN_DETAILS", CONTROL_ADMIN_DETAILS)
		.value("CONTROL_HALL_OF_FAME", CONTROL_HALL_OF_FAME)
		.value("CONTROL_WORLD_BUILDER", CONTROL_WORLD_BUILDER)
		.value("CONTROL_DIPLOMACY", CONTROL_DIPLOMACY)
		.value("CONTROL_SELECT_HEALTHY", CONTROL_SELECT_HEALTHY)
		.value("CONTROL_ESPIONAGE_SCREEN", CONTROL_ESPIONAGE_SCREEN)
		.value("CONTROL_FREE_COLONY", CONTROL_FREE_COLONY)

		.value("NUM_CONTROL_TYPES", NUM_CONTROL_TYPES)
		;

	python::enum_<PromotionTypes>("PromotionTypes")
		.value("NO_PROMOTION", NO_PROMOTION)
		;

	python::enum_<TechTypes>("TechTypes")
		.value("NO_TECH", NO_TECH)
		;

	python::enum_<SpecialistTypes>("SpecialistTypes")
		.value("NO_SPECIALIST", NO_SPECIALIST)
		;

	python::enum_<ReligionTypes>("ReligionTypes")
		.value("NO_RELIGION", NO_RELIGION)
		;

	python::enum_<CorporationTypes>("CorporationTypes")
		.value("NO_CORPORATION", NO_CORPORATION)
		;

	python::enum_<HurryTypes>("HurryTypes")
		.value("NO_HURRY", NO_HURRY)
		;

	python::enum_<UpkeepTypes>("UpkeepTypes")
		.value("NO_UPKEEP", NO_UPKEEP)
		;

	python::enum_<CultureLevelTypes>("CultureLevelTypes")
		.value("NO_CULTURELEVEL", NO_CULTURELEVEL)
		;

	python::enum_<CivicOptionTypes>("CivicOptionTypes")
		.value("NO_CIVICOPTION", NO_CIVICOPTION)
		;

	python::enum_<CivicTypes>("CivicTypes")
		.value("NO_CIVIC", NO_CIVIC)
		;

	python::enum_<WarPlanTypes>("WarPlanTypes")
		.value("NO_WARPLAN", NO_WARPLAN)
		.value("WARPLAN_ATTACKED_RECENT", WARPLAN_ATTACKED_RECENT)
		.value("WARPLAN_ATTACKED", WARPLAN_ATTACKED)
		.value("WARPLAN_PREPARING_LIMITED", WARPLAN_PREPARING_LIMITED)
		.value("WARPLAN_PREPARING_TOTAL", WARPLAN_PREPARING_TOTAL)
		.value("WARPLAN_LIMITED", WARPLAN_LIMITED)
		.value("WARPLAN_TOTAL", WARPLAN_TOTAL)
		.value("WARPLAN_DOGPILE", WARPLAN_DOGPILE)
		;

	python::enum_<AreaAITypes>("AreaAITypes")
		.value("NO_AREAAI", NO_AREAAI)
		.value("AREAAI_OFFENSIVE", AREAAI_OFFENSIVE)
		.value("AREAAI_DEFENSIVE", AREAAI_DEFENSIVE)
		.value("AREAAI_MASSING", AREAAI_MASSING)
		.value("AREAAI_ASSAULT", AREAAI_ASSAULT)
		.value("AREAAI_NEUTRAL", AREAAI_NEUTRAL)
		;

	python::enum_<EndTurnButtonStates>("EndTurnButtonStates")
		.value("END_TURN_GO", END_TURN_GO)
		.value("END_TURN_OVER_HIGHLIGHT", END_TURN_OVER_HIGHLIGHT)
		.value("END_TURN_OVER_DARK", END_TURN_OVER_DARK)
		.value("NUM_END_TURN_STATES", NUM_END_TURN_STATES)
		;

	python::enum_<FogOfWarModeTypes>("FogOfWarModeTypes")
		.value("FOGOFWARMODE_OFF", FOGOFWARMODE_OFF)
		.value("FOGOFWARMODE_UNEXPLORED", FOGOFWARMODE_UNEXPLORED)
		.value("NUM_FOGOFWARMODE_TYPES", NUM_FOGOFWARMODE_TYPES)
		;

	python::enum_<AnimationTypes>("AnimationTypes")
		.value("NONE_ANIMATION", NONE_ANIMATION)
		.value("BONUSANIMATION_UNIMPROVED", BONUSANIMATION_UNIMPROVED)
		.value("BONUSANIMATION_NOT_WORKED", BONUSANIMATION_NOT_WORKED)
		.value("BONUSANIMATION_WORKED", BONUSANIMATION_WORKED)
		.value("IMPROVEMENTANIMATION_OFF", IMPROVEMENTANIMATION_OFF)
		.value("IMPROVEMENTANIMATION_ON", IMPROVEMENTANIMATION_ON)
		.value("IMPROVEMENTANIMATION_OFF_EXTRA", IMPROVEMENTANIMATION_OFF_EXTRA)
		.value("IMPROVEMENTANIMATION_ON_EXTRA_1", IMPROVEMENTANIMATION_ON_EXTRA_1)
		.value("IMPROVEMENTANIMATION_ON_EXTRA_2", IMPROVEMENTANIMATION_ON_EXTRA_2)
		.value("IMPROVEMENTANIMATION_ON_EXTRA_3", IMPROVEMENTANIMATION_ON_EXTRA_3)
		.value("IMPROVEMENTANIMATION_ON_EXTRA_4", IMPROVEMENTANIMATION_ON_EXTRA_4)
		;

	python::enum_<EntityEventTypes>("EntityEventTypes")
		.value( "ENTITY_EVENT_NONE", ENTITY_EVENT_NONE )
		;

	python::enum_<AnimationPathTypes>("AnimationPathTypes")
		.value( "ANIMATIONPATH_NONE", ANIMATIONPATH_NONE )
		.value( "ANIMATIONPATH_IDLE", ANIMATIONPATH_IDLE )
		.value( "ANIMATIONPATH_MOVE", ANIMATIONPATH_MOVE )
		.value( "ANIMATIONPATH_RANDOMIZE_ANIMATION_SET", ANIMATIONPATH_RANDOMIZE_ANIMATION_SET )
		.value( "ANIMATIONPATH_NUKE_STRIKE", ANIMATIONPATH_NUKE_STRIKE )
		.value( "ANIMATIONPATH_MELEE_STRIKE", ANIMATIONPATH_MELEE_STRIKE )
		.value( "ANIMATIONPATH_MELEE_HURT", ANIMATIONPATH_MELEE_HURT )
		.value( "ANIMATIONPATH_MELEE_DIE", ANIMATIONPATH_MELEE_DIE )
		.value( "ANIMATIONPATH_MELEE_FORTIFIED", ANIMATIONPATH_MELEE_FORTIFIED )
		.value( "ANIMATIONPATH_MELEE_DIE_FADE", ANIMATIONPATH_MELEE_DIE_FADE )
		.value( "ANIMATIONPATH_RANGED_STRIKE", ANIMATIONPATH_RANGED_STRIKE )
		.value( "ANIMATIONPATH_RANGED_DIE", ANIMATIONPATH_RANGED_DIE )
		.value( "ANIMATIONPATH_RANGED_FORTIFIED", ANIMATIONPATH_RANGED_FORTIFIED )
		.value( "ANIMATIONPATH_RANGED_RUNHIT", ANIMATIONPATH_RANGED_RUNHIT )
		.value( "ANIMATIONPATH_RANGED_RUNDIE", ANIMATIONPATH_RANGED_RUNDIE )
		.value( "ANIMATIONPATH_RANGED_DIE_FADE", ANIMATIONPATH_RANGED_DIE_FADE )
		.value( "ANIMATIONPATH_LEADER_COMMAND", ANIMATIONPATH_LEADER_COMMAND )
		.value( "ANIMATIONPATH_AIRFADEIN", ANIMATIONPATH_AIRFADEIN )
		.value( "ANIMATIONPATH_AIRFADEOUT", ANIMATIONPATH_AIRFADEOUT )
		.value( "ANIMATIONPATH_AIRSTRIKE", ANIMATIONPATH_AIRSTRIKE )
		.value( "ANIMATIONPATH_AIRBOMB", ANIMATIONPATH_AIRBOMB )
		;

	python::enum_<AnimationCategoryTypes>("AnimationCategoryTypes")
		.value("ANIMCAT_NONE", ANIMCAT_NONE)
		;

	python::enum_<CursorTypes>("CursorTypes")
		.value("NO_CURSOR", NO_CURSOR)
		;

	python::enum_<TradeableItems>("TradeableItems")
		.value("NO_TRADEABLE_ITEMS", TRADE_ITEM_NONE)
		.value("TRADE_GOLD", TRADE_GOLD)
		.value("TRADE_GOLD_PER_TURN", TRADE_GOLD_PER_TURN)
		.value("TRADE_MAPS", TRADE_MAPS)
		.value("TRADE_VASSAL", TRADE_VASSAL)
		.value("TRADE_SURRENDER", TRADE_SURRENDER)
		.value("TRADE_OPEN_BORDERS", TRADE_OPEN_BORDERS)
		.value("TRADE_DEFENSIVE_PACT", TRADE_DEFENSIVE_PACT)
		.value("TRADE_PERMANENT_ALLIANCE", TRADE_PERMANENT_ALLIANCE)
		.value("TRADE_PEACE_TREATY", TRADE_PEACE_TREATY)
		.value("NUM_BASIC_ITEMS", NUM_BASIC_ITEMS)
		.value("TRADE_TECHNOLOGIES", TRADE_TECHNOLOGIES)
		.value("TRADE_RESOURCES", TRADE_RESOURCES)
		.value("TRADE_CITIES", TRADE_CITIES)
		.value("TRADE_PEACE", TRADE_PEACE)
		.value("TRADE_WAR", TRADE_WAR)
		.value("TRADE_EMBARGO", TRADE_EMBARGO)
		.value("TRADE_CIVIC", TRADE_CIVIC)
		.value("TRADE_RELIGION", TRADE_RELIGION)
		.value("NUM_TRADEABLE_HEADINGS", NUM_TRADEABLE_HEADINGS)
		.value("NUM_TRADEABLE_ITEMS", NUM_TRADEABLE_ITEMS)
		;

	python::enum_<DiploEventTypes>("DiploEventTypes")
		.value("NO_DIPLOEVENT", NO_DIPLOEVENT)
		.value("DIPLOEVENT_CONTACT", DIPLOEVENT_CONTACT)
		.value("DIPLOEVENT_AI_CONTACT", DIPLOEVENT_AI_CONTACT)
		.value("DIPLOEVENT_FAILED_CONTACT", DIPLOEVENT_FAILED_CONTACT)
		.value("DIPLOEVENT_GIVE_HELP", DIPLOEVENT_GIVE_HELP)
		.value("DIPLOEVENT_REFUSED_HELP", DIPLOEVENT_REFUSED_HELP)
		.value("DIPLOEVENT_ACCEPT_DEMAND", DIPLOEVENT_ACCEPT_DEMAND)
		.value("DIPLOEVENT_REJECTED_DEMAND", DIPLOEVENT_REJECTED_DEMAND)
		.value("DIPLOEVENT_DEMAND_WAR", DIPLOEVENT_DEMAND_WAR)
		.value("DIPLOEVENT_CONVERT", DIPLOEVENT_CONVERT)
		.value("DIPLOEVENT_NO_CONVERT", DIPLOEVENT_NO_CONVERT)
		.value("DIPLOEVENT_REVOLUTION", DIPLOEVENT_REVOLUTION)
		.value("DIPLOEVENT_NO_REVOLUTION", DIPLOEVENT_NO_REVOLUTION)
		.value("DIPLOEVENT_JOIN_WAR", DIPLOEVENT_JOIN_WAR)
		.value("DIPLOEVENT_NO_JOIN_WAR", DIPLOEVENT_NO_JOIN_WAR)
		.value("DIPLOEVENT_STOP_TRADING", DIPLOEVENT_STOP_TRADING)
		.value("DIPLOEVENT_NO_STOP_TRADING", DIPLOEVENT_NO_STOP_TRADING)
		.value("DIPLOEVENT_ASK_HELP", DIPLOEVENT_ASK_HELP)
		.value("DIPLOEVENT_MADE_DEMAND", DIPLOEVENT_MADE_DEMAND)
		.value("DIPLOEVENT_RESEARCH_TECH", DIPLOEVENT_RESEARCH_TECH)
		.value("DIPLOEVENT_TARGET_CITY", DIPLOEVENT_TARGET_CITY)
		.value("DIPLOEVENT_MADE_DEMAND_VASSAL", DIPLOEVENT_MADE_DEMAND_VASSAL)
		.value("NUM_DIPLOEVENT_TYPES", NUM_DIPLOEVENT_TYPES)
		;

	python::enum_<DiploCommentTypes>("DiploCommentTypes")
		.value("NO_DIPLOCOMMENT", NO_DIPLOCOMMENT)
		;

	python::enum_<NetContactTypes>("NetContactTypes")
		.value("NO_NETCONTACT", NO_NETCONTACT)
		.value("NETCONTACT_INITIAL", NETCONTACT_INITIAL)
		.value("NETCONTACT_RESPONSE", NETCONTACT_RESPONSE)
		.value("NETCONTACT_ESTABLISHED", NETCONTACT_ESTABLISHED)
		.value("NETCONTACT_BUSY", NETCONTACT_BUSY)
		.value("NUM_NETCONTACT_TYPES", NUM_NETCONTACT_TYPES)
		;

	python::enum_<ContactTypes>("ContactTypes")
		.value("CONTACT_RELIGION_PRESSURE", CONTACT_RELIGION_PRESSURE)
		.value("CONTACT_CIVIC_PRESSURE", CONTACT_CIVIC_PRESSURE)
		.value("CONTACT_JOIN_WAR", CONTACT_JOIN_WAR)
		.value("CONTACT_STOP_TRADING", CONTACT_STOP_TRADING)
		.value("CONTACT_GIVE_HELP", CONTACT_GIVE_HELP)
		.value("CONTACT_ASK_FOR_HELP", CONTACT_ASK_FOR_HELP)
		.value("CONTACT_DEMAND_TRIBUTE", CONTACT_DEMAND_TRIBUTE)
		.value("CONTACT_OPEN_BORDERS", CONTACT_OPEN_BORDERS)
		.value("CONTACT_DEFENSIVE_PACT", CONTACT_DEFENSIVE_PACT)
		.value("CONTACT_PERMANENT_ALLIANCE", CONTACT_PERMANENT_ALLIANCE)
		.value("CONTACT_PEACE_TREATY", CONTACT_PEACE_TREATY)
		.value("CONTACT_TRADE_TECH", CONTACT_TRADE_TECH)
		.value("CONTACT_TRADE_BONUS", CONTACT_TRADE_BONUS)
		.value("CONTACT_TRADE_MAP", CONTACT_TRADE_MAP)
		.value("NUM_CONTACT_TYPES", NUM_CONTACT_TYPES)
		;

	python::enum_<MemoryTypes>("MemoryTypes")
		.value("MEMORY_DECLARED_WAR", MEMORY_DECLARED_WAR)
		.value("MEMORY_DECLARED_WAR_ON_FRIEND", MEMORY_DECLARED_WAR_ON_FRIEND)
		.value("MEMORY_HIRED_WAR_ALLY", MEMORY_HIRED_WAR_ALLY)
		.value("MEMORY_NUKED_US", MEMORY_NUKED_US)
		.value("MEMORY_NUKED_FRIEND", MEMORY_NUKED_FRIEND)
		.value("MEMORY_RAZED_CITY", MEMORY_RAZED_CITY)
		.value("MEMORY_RAZED_HOLY_CITY", MEMORY_RAZED_HOLY_CITY)
		.value("MEMORY_SPY_CAUGHT", MEMORY_SPY_CAUGHT)
		.value("MEMORY_GIVE_HELP", MEMORY_GIVE_HELP)
		.value("MEMORY_REFUSED_HELP", MEMORY_REFUSED_HELP)
		.value("MEMORY_ACCEPT_DEMAND", MEMORY_ACCEPT_DEMAND)
		.value("MEMORY_REJECTED_DEMAND", MEMORY_REJECTED_DEMAND)
		.value("MEMORY_ACCEPTED_RELIGION", MEMORY_ACCEPTED_RELIGION)
		.value("MEMORY_DENIED_RELIGION", MEMORY_DENIED_RELIGION)
		.value("MEMORY_ACCEPTED_CIVIC", MEMORY_ACCEPTED_CIVIC)
		.value("MEMORY_DENIED_CIVIC", MEMORY_DENIED_CIVIC)
		.value("MEMORY_ACCEPTED_JOIN_WAR", MEMORY_ACCEPTED_JOIN_WAR)
		.value("MEMORY_DENIED_JOIN_WAR", MEMORY_DENIED_JOIN_WAR)
		.value("MEMORY_ACCEPTED_STOP_TRADING", MEMORY_ACCEPTED_STOP_TRADING)
		.value("MEMORY_DENIED_STOP_TRADING", MEMORY_DENIED_STOP_TRADING)
		.value("MEMORY_STOPPED_TRADING", MEMORY_STOPPED_TRADING)
		.value("MEMORY_STOPPED_TRADING_RECENT", MEMORY_STOPPED_TRADING_RECENT)
		.value("MEMORY_HIRED_TRADE_EMBARGO", MEMORY_HIRED_TRADE_EMBARGO)
		.value("MEMORY_MADE_DEMAND", MEMORY_MADE_DEMAND)
		.value("MEMORY_MADE_DEMAND_RECENT", MEMORY_MADE_DEMAND_RECENT)
		.value("MEMORY_CANCELLED_OPEN_BORDERS", MEMORY_CANCELLED_OPEN_BORDERS)
		.value("MEMORY_TRADED_TECH_TO_US", MEMORY_TRADED_TECH_TO_US)
		.value("MEMORY_RECEIVED_TECH_FROM_ANY", MEMORY_RECEIVED_TECH_FROM_ANY)
		.value("MEMORY_VOTED_AGAINST_US", MEMORY_VOTED_AGAINST_US)
		.value("MEMORY_VOTED_FOR_US", MEMORY_VOTED_FOR_US)
		.value("MEMORY_EVENT_GOOD_TO_US", MEMORY_EVENT_GOOD_TO_US)
		.value("MEMORY_EVENT_BAD_TO_US", MEMORY_EVENT_BAD_TO_US)
		.value("MEMORY_LIBERATED_CITIES", MEMORY_LIBERATED_CITIES)
		.value("MEMORY_POLITICAL_MARRIAGE", MEMORY_POLITICAL_MARRIAGE)//David Allen Espionage Mission
		.value("NUM_MEMORY_TYPES", NUM_MEMORY_TYPES)
		;

	python::enum_<AttitudeTypes>("AttitudeTypes")
		.value("NO_ATTITUDE", NO_ATTITUDE)
		.value("ATTITUDE_FURIOUS", ATTITUDE_FURIOUS)
		.value("ATTITUDE_ANNOYED", ATTITUDE_ANNOYED)
		.value("ATTITUDE_CAUTIOUS", ATTITUDE_CAUTIOUS)
		.value("ATTITUDE_PLEASED", ATTITUDE_PLEASED)
		.value("ATTITUDE_FRIENDLY", ATTITUDE_FRIENDLY)
		.value("NUM_ATTITUDE_TYPES", NUM_ATTITUDE_TYPES)
		;

	python::enum_<LeaderheadAction>("LeaderheadAction")
		.value( "NO_LEADERANIM", NO_LEADERANIM )
		.value( "LEADERANIM_GREETING", LEADERANIM_GREETING )
		.value( "LEADERANIM_FRIENDLY", LEADERANIM_FRIENDLY )
		.value( "LEADERANIM_PLEASED", LEADERANIM_PLEASED )
		.value( "LEADERANIM_CAUTIOUS", LEADERANIM_CAUTIOUS )
		.value( "LEADERANIM_ANNOYED", LEADERANIM_ANNOYED )
		.value( "LEADERANIM_FURIOUS", LEADERANIM_FURIOUS )
		.value( "LEADERANIM_DISAGREE", LEADERANIM_DISAGREE )
		.value( "LEADERANIM_AGREE", LEADERANIM_AGREE )
		.value( "NUM_LEADERANIM_TYPES", NUM_LEADERANIM_TYPES )
		;

	python::enum_<DiplomacyPowerTypes>("DiplomacyPowerTypes")
		.value("NO_DIPLOMACYPOWER", NO_DIPLOMACYPOWER)
		.value("DIPLOMACYPOWER_WEAKER", DIPLOMACYPOWER_WEAKER)
		.value("DIPLOMACYPOWER_EQUAL", DIPLOMACYPOWER_EQUAL)
		.value("DIPLOMACYPOWER_STRONGER", DIPLOMACYPOWER_STRONGER)
		.value("NUM_DIPLOMACYPOWER_TYPES", NUM_DIPLOMACYPOWER_TYPES)
		;

	python::enum_<FeatTypes>("FeatTypes")
		.value("FEAT_UNITCOMBAT_ARCHER", FEAT_UNITCOMBAT_ARCHER)
		.value("FEAT_UNITCOMBAT_MOUNTED", FEAT_UNITCOMBAT_MOUNTED)
		.value("FEAT_UNITCOMBAT_MELEE", FEAT_UNITCOMBAT_MELEE)
		.value("FEAT_UNITCOMBAT_SIEGE", FEAT_UNITCOMBAT_SIEGE)
		.value("FEAT_UNITCOMBAT_GUN", FEAT_UNITCOMBAT_GUN)
		.value("FEAT_UNITCOMBAT_ARMOR", FEAT_UNITCOMBAT_ARMOR)
		.value("FEAT_UNITCOMBAT_HELICOPTER", FEAT_UNITCOMBAT_HELICOPTER)
		.value("FEAT_UNITCOMBAT_NAVAL", FEAT_UNITCOMBAT_NAVAL)
		.value("FEAT_UNIT_PRIVATEER", FEAT_UNIT_PRIVATEER)
		.value("FEAT_UNIT_SPY", FEAT_UNIT_SPY)
		.value("FEAT_NATIONAL_WONDER", FEAT_NATIONAL_WONDER)
		.value("FEAT_TRADE_ROUTE", FEAT_TRADE_ROUTE)
		.value("FEAT_COPPER_CONNECTED", FEAT_COPPER_CONNECTED)
		.value("FEAT_HORSE_CONNECTED", FEAT_HORSE_CONNECTED)
		.value("FEAT_IRON_CONNECTED", FEAT_IRON_CONNECTED)
		.value("FEAT_LUXURY_CONNECTED", FEAT_LUXURY_CONNECTED)
		.value("FEAT_FOOD_CONNECTED", FEAT_FOOD_CONNECTED)
		.value("FEAT_POPULATION_HALF_MILLION", FEAT_POPULATION_HALF_MILLION)
		.value("FEAT_POPULATION_1_MILLION", FEAT_POPULATION_1_MILLION)
		.value("FEAT_POPULATION_2_MILLION", FEAT_POPULATION_2_MILLION)
		.value("FEAT_POPULATION_5_MILLION", FEAT_POPULATION_5_MILLION)
		.value("FEAT_POPULATION_10_MILLION", FEAT_POPULATION_10_MILLION)
		.value("FEAT_POPULATION_20_MILLION", FEAT_POPULATION_20_MILLION)
		.value("FEAT_POPULATION_50_MILLION", FEAT_POPULATION_50_MILLION)
		.value("FEAT_POPULATION_100_MILLION", FEAT_POPULATION_100_MILLION)
		.value("FEAT_POPULATION_200_MILLION", FEAT_POPULATION_200_MILLION)
		.value("FEAT_POPULATION_500_MILLION", FEAT_POPULATION_500_MILLION)
		.value("FEAT_POPULATION_1_BILLION", FEAT_POPULATION_1_BILLION)
		.value("FEAT_POPULATION_2_BILLION", FEAT_POPULATION_2_BILLION)
		.value("FEAT_CORPORATION_ENABLED", FEAT_CORPORATION_ENABLED)
		.value("FEAT_PAD", FEAT_PAD)
		.value("NUM_FEAT_TYPES", NUM_FEAT_TYPES)
		;

	python::enum_<SaveGameTypes>("SaveGameTypes")
		.value("SAVEGAME_NONE", SAVEGAME_NONE)
		.value("SAVEGAME_AUTO", SAVEGAME_AUTO)
		.value("SAVEGAME_RECOVERY", SAVEGAME_RECOVERY)
		.value("SAVEGAME_QUICK", SAVEGAME_QUICK)
		.value("SAVEGAME_NORMAL", SAVEGAME_NORMAL)
		.value("SAVEGAME_GROUP", SAVEGAME_GROUP)
		.value("SAVEGAME_DROP_QUIT", SAVEGAME_DROP_QUIT)
		.value("SAVEGAME_DROP_CONTINUE", SAVEGAME_DROP_CONTINUE)
		.value("SAVEGAME_PBEM", SAVEGAME_PBEM)
		.value("SAVEGAME_REPLAY", SAVEGAME_REPLAY)
		.value("NUM_SAVEGAME_TYPES", NUM_SAVEGAME_TYPES)
		;

	python::enum_<GameType>("GameType")
		.value("GAME_NONE", GAME_NONE)
		.value("GAME_SP_NEW", GAME_SP_NEW)
		.value("GAME_SP_SCENARIO", GAME_SP_SCENARIO)
		.value("GAME_SP_LOAD", GAME_SP_LOAD)
		.value("GAME_MP_NEW", GAME_MP_NEW)
		.value("GAME_MP_SCENARIO", GAME_MP_SCENARIO)
		.value("GAME_MP_LOAD", GAME_MP_LOAD)
		.value("GAME_HOTSEAT_NEW", GAME_HOTSEAT_NEW)
		.value("GAME_HOTSEAT_SCENARIO", GAME_HOTSEAT_SCENARIO)
		.value("GAME_HOTSEAT_LOAD", GAME_HOTSEAT_LOAD)
		.value("GAME_PBEM_NEW", GAME_PBEM_NEW)
		.value("GAME_PBEM_SCENARIO", GAME_PBEM_SCENARIO)
		.value("GAME_PBEM_LOAD", GAME_PBEM_LOAD)
		.value("GAME_REPLAY", GAME_REPLAY)
		.value("NUM_GAMETYPES", NUM_GAMETYPES)
		;

	python::enum_<GameMode>("GameMode")
		.value("NO_GAMEMODE", NO_GAMEMODE)
		.value("GAMEMODE_NORMAL", GAMEMODE_NORMAL)
		.value("GAMEMODE_PITBOSS", GAMEMODE_PITBOSS)
		.value("NUM_GAMEMODES", NUM_GAMEMODES)
		;

	python::enum_<InterfaceVisibility>("InterfaceVisibility")
		.value("INTERFACE_SHOW", INTERFACE_SHOW)
		.value("INTERFACE_HIDE", INTERFACE_HIDE)
		.value("INTERFACE_HIDE_ALL", INTERFACE_HIDE_ALL)
		.value("INTERFACE_MINIMAP_ONLY", INTERFACE_MINIMAP_ONLY)
		.value("INTERFACE_ADVANCED_START", INTERFACE_ADVANCED_START)
		;

	python::enum_<GenericButtonSizes>("GenericButtonSizes")
		.value("BUTTON_SIZE_46", BUTTON_SIZE_46)
		.value("BUTTON_SIZE_32", BUTTON_SIZE_32)
		.value("BUTTON_SIZE_24", BUTTON_SIZE_24)
		.value("BUTTON_SIZE_16", BUTTON_SIZE_16)
		.value("BUTTON_SIZE_CUSTOM", BUTTON_SIZE_CUSTOM)
		;

	python::enum_<WorldBuilderPopupTypes>("WorldBuilderPopupTypes")
		.value("WBPOPUP_NONE", WBPOPUP_NONE)
		.value("WBPOPUP_START", WBPOPUP_START)
		.value("WBPOPUP_CITY", WBPOPUP_CITY)
		.value("WBPOPUP_UNIT", WBPOPUP_UNIT)
		.value("WBPOPUP_PLAYER", WBPOPUP_PLAYER)
		.value("WBPOPUP_PLOT", WBPOPUP_PLOT)
		.value("WBPOPUP_TERRAIN", WBPOPUP_TERRAIN)
		.value("WBPOPUP_FEATURE", WBPOPUP_FEATURE)
		.value("WBPOPUP_IMPROVEMENT", WBPOPUP_IMPROVEMENT)
		.value("WBPOPUP_GAME", WBPOPUP_GAME)
		.value("NUM_WBPOPUP", NUM_WBPOPUP)
		;

	python::enum_<EventType>("EventType")
		.value("EVT_LBUTTONDOWN", EVT_LBUTTONDOWN)
		.value("EVT_LBUTTONDBLCLICK", EVT_LBUTTONDBLCLICK)
		.value("EVT_RBUTTONDOWN", EVT_RBUTTONDOWN)
		.value("EVT_BACK", EVT_BACK)
		.value("EVT_FORWARD", EVT_FORWARD)
		.value("EVT_KEYDOWN", EVT_KEYDOWN)
		.value("EVT_KEYUP", EVT_KEYUP)
		;

	python::enum_<LoadType>("LoadType")
		.value("LOAD_NORMAL", LOAD_NORMAL)
		.value("LOAD_INIT", LOAD_INIT)
		.value("LOAD_SETUP", LOAD_SETUP)
		.value("LOAD_GAMETYPE", LOAD_GAMETYPE)
		.value("LOAD_REPLAY", LOAD_REPLAY)
		;

	python::enum_<FontTypes>("FontTypes")
		.value("TITLE_FONT", TITLE_FONT)
		.value("GAME_FONT", GAME_FONT)
		.value("SMALL_FONT", SMALL_FONT)
		.value("MENU_FONT", MENU_FONT)
		.value("MENU_HIGHLIGHT_FONT", MENU_HIGHLIGHT_FONT)
		;

	python::enum_<PanelStyles>("PanelStyles")
		.value("PANEL_STYLE_STANDARD",PANEL_STYLE_STANDARD)
		.value("PANEL_STYLE_SOLID",PANEL_STYLE_SOLID)
		.value("PANEL_STYLE_EMPTY",PANEL_STYLE_EMPTY)
		.value("PANEL_STYLE_FLAT",PANEL_STYLE_FLAT)
		.value("PANEL_STYLE_IN",PANEL_STYLE_IN)
		.value("PANEL_STYLE_OUT",PANEL_STYLE_OUT)
		.value("PANEL_STYLE_EXTERNAL",PANEL_STYLE_EXTERNAL)
		.value("PANEL_STYLE_DEFAULT",PANEL_STYLE_DEFAULT)

		.value("PANEL_STYLE_CIVILPEDIA",PANEL_STYLE_CIVILPEDIA)
		.value("PANEL_STYLE_STONE",PANEL_STYLE_STONE)
		.value("PANEL_STYLE_BLUELARGE",PANEL_STYLE_BLUELARGE)
		.value("PANEL_STYLE_UNITSTAT",PANEL_STYLE_UNITSTAT)
		.value("PANEL_STYLE_BLUE50",PANEL_STYLE_BLUE50)
		
		.value("PANEL_STYLE_TOPBAR",PANEL_STYLE_TOPBAR)
		.value("PANEL_STYLE_BOTTOMBAR",PANEL_STYLE_BOTTOMBAR)
		.value("PANEL_STYLE_TECH",PANEL_STYLE_TECH)

		.value("PANEL_STYLE_GAMEHUD_LEFT",PANEL_STYLE_GAMEHUD_LEFT)
		.value("PANEL_STYLE_GAMEHUD_RIGHT",PANEL_STYLE_GAMEHUD_RIGHT)
		.value("PANEL_STYLE_GAMEHUD_CENTER",PANEL_STYLE_GAMEHUD_CENTER)
		.value("PANEL_STYLE_GAMEHUD_STATS",PANEL_STYLE_GAMEHUD_STATS)
		.value("PANEL_STYLE_GAME_MAP",PANEL_STYLE_GAME_MAP)
		.value("PANEL_STYLE_GAME_TOPBAR",PANEL_STYLE_GAME_TOPBAR)
		.value("PANEL_STYLE_HUD_HELP", PANEL_STYLE_HUD_HELP)

		.value("PANEL_STYLE_CITY_LEFT",PANEL_STYLE_CITY_LEFT)
		.value("PANEL_STYLE_CITY_RIGHT",PANEL_STYLE_CITY_RIGHT)
		.value("PANEL_STYLE_CITY_TOP",PANEL_STYLE_CITY_TOP)
		.value("PANEL_STYLE_CITY_TANSHADE",PANEL_STYLE_CITY_TANSHADE)
		.value("PANEL_STYLE_CITY_INFO",PANEL_STYLE_CITY_INFO)
		.value("PANEL_STYLE_CITY_TANTL",PANEL_STYLE_CITY_TANTL)
		.value("PANEL_STYLE_CITY_TANTR",PANEL_STYLE_CITY_TANTR)
		.value("PANEL_STYLE_CITY_COLUMNL",PANEL_STYLE_CITY_COLUMNL)
		.value("PANEL_STYLE_CITY_COLUMNC",PANEL_STYLE_CITY_COLUMNC)
		.value("PANEL_STYLE_CITY_COLUMNR",PANEL_STYLE_CITY_COLUMNR)
		.value("PANEL_STYLE_CITY_TITLE",PANEL_STYLE_CITY_TITLE)
	
		.value("PANEL_STYLE_DAWN",PANEL_STYLE_DAWN)
		.value("PANEL_STYLE_DAWNTOP",PANEL_STYLE_DAWNTOP)
		.value("PANEL_STYLE_DAWNBOTTOM",PANEL_STYLE_DAWNBOTTOM)

		.value("PANEL_STYLE_MAIN",PANEL_STYLE_MAIN)
		.value("PANEL_STYLE_MAIN_BLACK25",PANEL_STYLE_MAIN_BLACK25)
		.value("PANEL_STYLE_MAIN_BLACK50",PANEL_STYLE_MAIN_BLACK50)
		.value("PANEL_STYLE_MAIN_WHITE",PANEL_STYLE_MAIN_WHITE)
		.value("PANEL_STYLE_MAIN_WHITETAB",PANEL_STYLE_MAIN_WHITETAB)
		.value("PANEL_STYLE_MAIN_TAN",PANEL_STYLE_MAIN_TAN)
		.value("PANEL_STYLE_MAIN_TAN15",PANEL_STYLE_MAIN_TAN15)
		.value("PANEL_STYLE_MAIN_TANL",PANEL_STYLE_MAIN_TANL)
		.value("PANEL_STYLE_MAIN_TANR",PANEL_STYLE_MAIN_TANR)
		.value("PANEL_STYLE_MAIN_TANT",PANEL_STYLE_MAIN_TANT)
		.value("PANEL_STYLE_MAIN_TANB",PANEL_STYLE_MAIN_TANB)
		.value("PANEL_STYLE_MAIN_BOTTOMBAR",PANEL_STYLE_MAIN_BOTTOMBAR)
		.value("PANEL_STYLE_MAIN_SELECT",PANEL_STYLE_MAIN_SELECT)
		;

	python::enum_<ButtonStyles>("ButtonStyles")
		.value("BUTTON_STYLE_STANDARD", BUTTON_STYLE_STANDARD)
		.value("BUTTON_STYLE_ETCHED", BUTTON_STYLE_ETCHED)
		.value("BUTTON_STYLE_FLAT", BUTTON_STYLE_FLAT)
		.value("BUTTON_STYLE_IMAGE", BUTTON_STYLE_IMAGE)
		.value("BUTTON_STYLE_LABEL", BUTTON_STYLE_LABEL)
		.value("BUTTON_STYLE_LINK", BUTTON_STYLE_LINK)
		.value("BUTTON_STYLE_SQUARE", BUTTON_STYLE_SQUARE)
		.value("BUTTON_STYLE_TOOL", BUTTON_STYLE_TOOL)
		.value("BUTTON_STYLE_DEFAULT", BUTTON_STYLE_DEFAULT)
		
		.value("BUTTON_STYLE_CIRCLE", BUTTON_STYLE_CIRCLE)
		.value("BUTTON_STYLE_CITY_B01", BUTTON_STYLE_CITY_B01)
		.value("BUTTON_STYLE_CITY_B02TL", BUTTON_STYLE_CITY_B02TL)
		.value("BUTTON_STYLE_CITY_B02TR", BUTTON_STYLE_CITY_B02TR)
		.value("BUTTON_STYLE_CITY_B02BL", BUTTON_STYLE_CITY_B02BL)
		.value("BUTTON_STYLE_CITY_B02BR", BUTTON_STYLE_CITY_B02BR)
		.value("BUTTON_STYLE_CITY_B03TL", BUTTON_STYLE_CITY_B03TL)
		.value("BUTTON_STYLE_CITY_B03TC", BUTTON_STYLE_CITY_B03TC)
		.value("BUTTON_STYLE_CITY_B03TR", BUTTON_STYLE_CITY_B03TR)
		.value("BUTTON_STYLE_CITY_B03BL", BUTTON_STYLE_CITY_B03BL)
		.value("BUTTON_STYLE_CITY_B03BC", BUTTON_STYLE_CITY_B03BC)
		.value("BUTTON_STYLE_CITY_B03BR", BUTTON_STYLE_CITY_B03BR)
		.value("BUTTON_STYLE_CITY_FLAT", BUTTON_STYLE_CITY_FLAT)
		.value("BUTTON_STYLE_CITY_PLUS", BUTTON_STYLE_CITY_PLUS)
		.value("BUTTON_STYLE_CITY_MINUS", BUTTON_STYLE_CITY_MINUS)
		.value("BUTTON_STYLE_ARROW_LEFT", BUTTON_STYLE_ARROW_LEFT)
		.value("BUTTON_STYLE_ARROW_RIGHT", BUTTON_STYLE_ARROW_RIGHT)
		;

	python::enum_<TableStyles>("TableStyles")
		.value("TABLE_STYLE_STANDARD", TABLE_STYLE_STANDARD)
		.value("TABLE_STYLE_EMPTY", TABLE_STYLE_EMPTY)
		.value("TABLE_STYLE_ALTEMPTY", TABLE_STYLE_ALTEMPTY)
		.value("TABLE_STYLE_CITY", TABLE_STYLE_CITY)
		.value("TABLE_STYLE_EMPTYSELECTINACTIVE", TABLE_STYLE_EMPTYSELECTINACTIVE)
		.value("TABLE_STYLE_ALTDEFAULT", TABLE_STYLE_ALTDEFAULT)
		.value("TABLE_STYLE_STAGINGROOM", TABLE_STYLE_STAGINGROOM)
		;

	python::enum_<EventContextTypes>("EventContextTypes")
		.value("NO_EVENTCONTEXT", NO_EVENTCONTEXT)
		.value("EVENTCONTEXT_SELF", EVENTCONTEXT_SELF)
		.value("EVENTCONTEXT_ALL", EVENTCONTEXT_ALL)
		;

	python::enum_<TabGroupTypes>("TabGroupTypes")
		.value("NO_TABGROUP", NO_TABGROUP)

		.value("TABGROUP_GAME", TABGROUP_GAME)
		.value("TABGROUP_INPUT", TABGROUP_INPUT)
		.value("TABGROUP_GRAPHICS", TABGROUP_GRAPHICS)
		.value("TABGROUP_AUDIO", TABGROUP_AUDIO)
		.value("TABGROUP_CLOCK", TABGROUP_CLOCK)

		.value("NUM_TABGROUPS", NUM_TABGROUPS)
		;

	python::enum_<ReplayMessageTypes>("ReplayMessageTypes")
		.value("NO_REPLAY_MESSAGE", NO_REPLAY_MESSAGE)

		.value("REPLAY_MESSAGE_MAJOR_EVENT", REPLAY_MESSAGE_MAJOR_EVENT)
		.value("REPLAY_MESSAGE_CITY_FOUNDED", REPLAY_MESSAGE_CITY_FOUNDED)
		.value("REPLAY_MESSAGE_PLOT_OWNER_CHANGE", REPLAY_MESSAGE_PLOT_OWNER_CHANGE)

		.value("NUM_REPLAY_MESSAGE_TYPES", NUM_REPLAY_MESSAGE_TYPES)
		;

	python::enum_<AudioTag>("AudioTag")
		.value("AUDIOTAG_NONE", AUDIOTAG_NONE)
		.value("AUDIOTAG_SOUNDID", AUDIOTAG_SOUNDID)
		.value("AUDIOTAG_CONTEXTID", AUDIOTAG_CONTEXTID)
		.value("AUDIOTAG_SOUNDTYPE", AUDIOTAG_SOUNDTYPE)
		.value("AUDIOTAG_2DSCRIPT", AUDIOTAG_2DSCRIPT)
		.value("AUDIOTAG_3DSCRIPT", AUDIOTAG_3DSCRIPT)
		.value("AUDIOTAG_SOUNDSCAPE", AUDIOTAG_SOUNDSCAPE)
		.value("AUDIOTAG_POSITION", AUDIOTAG_POSITION)
		.value("AUDIOTAG_SCRIPTTYPE", AUDIOTAG_SCRIPTTYPE)
		.value("AUDIOTAG_LOADTYPE", AUDIOTAG_LOADTYPE)
		.value("AUDIOTAG_COUNT", AUDIOTAG_COUNT)
		;

	python::enum_<CivilopediaPageTypes>("CivilopediaPageTypes")
		.value("NO_CIVILOPEDIA_PAGE", NO_CIVILOPEDIA_PAGE)

		.value("CIVILOPEDIA_PAGE_TECH", CIVILOPEDIA_PAGE_TECH)
		.value("CIVILOPEDIA_PAGE_UNIT", CIVILOPEDIA_PAGE_UNIT)
		.value("CIVILOPEDIA_PAGE_BUILDING", CIVILOPEDIA_PAGE_BUILDING)
		.value("CIVILOPEDIA_PAGE_WONDER", CIVILOPEDIA_PAGE_WONDER)
		.value("CIVILOPEDIA_PAGE_BONUS", CIVILOPEDIA_PAGE_BONUS)
		.value("CIVILOPEDIA_PAGE_IMPROVEMENT", CIVILOPEDIA_PAGE_IMPROVEMENT)
		.value("CIVILOPEDIA_PAGE_PROMOTION", CIVILOPEDIA_PAGE_PROMOTION)
		.value("CIVILOPEDIA_PAGE_UNIT_GROUP", CIVILOPEDIA_PAGE_UNIT_GROUP)
		.value("CIVILOPEDIA_PAGE_CIV", CIVILOPEDIA_PAGE_CIV)
		.value("CIVILOPEDIA_PAGE_LEADER", CIVILOPEDIA_PAGE_LEADER)
		.value("CIVILOPEDIA_PAGE_RELIGION", CIVILOPEDIA_PAGE_RELIGION)
		.value("CIVILOPEDIA_PAGE_CORPORATION", CIVILOPEDIA_PAGE_CORPORATION)
		.value("CIVILOPEDIA_PAGE_CIVIC", CIVILOPEDIA_PAGE_CIVIC)
		.value("CIVILOPEDIA_PAGE_PROJECT", CIVILOPEDIA_PAGE_PROJECT)
		.value("CIVILOPEDIA_PAGE_CONCEPT", CIVILOPEDIA_PAGE_CONCEPT)
		.value("CIVILOPEDIA_PAGE_CONCEPT_NEW", CIVILOPEDIA_PAGE_CONCEPT_NEW)
		.value("CIVILOPEDIA_PAGE_SPECIALIST", CIVILOPEDIA_PAGE_SPECIALIST)
		.value("CIVILOPEDIA_PAGE_TERRAIN", CIVILOPEDIA_PAGE_TERRAIN)
		.value("CIVILOPEDIA_PAGE_FEATURE", CIVILOPEDIA_PAGE_FEATURE)
		.value("CIVILOPEDIA_PAGE_HINTS", CIVILOPEDIA_PAGE_HINTS)

		.value("NUM_CIVILOPEDIA_PAGE_TYPES", NUM_CIVILOPEDIA_PAGE_TYPES)
		;

	python::enum_<ActionSubTypes>("ActionSubTypes")
		.value("NO_ACTIONSUBTYPE", NO_ACTIONSUBTYPE)

		.value("ACTIONSUBTYPE_INTERFACEMODE", ACTIONSUBTYPE_INTERFACEMODE)
		.value("ACTIONSUBTYPE_COMMAND", ACTIONSUBTYPE_COMMAND)
		.value("ACTIONSUBTYPE_BUILD", ACTIONSUBTYPE_BUILD)
		.value("ACTIONSUBTYPE_PROMOTION", ACTIONSUBTYPE_PROMOTION)
		.value("ACTIONSUBTYPE_UNIT", ACTIONSUBTYPE_UNIT)
		.value("ACTIONSUBTYPE_RELIGION", ACTIONSUBTYPE_RELIGION)
		.value("ACTIONSUBTYPE_SPECIALIST", ACTIONSUBTYPE_SPECIALIST)
		.value("ACTIONSUBTYPE_BUILDING", ACTIONSUBTYPE_BUILDING)
		.value("ACTIONSUBTYPE_CONTROL", ACTIONSUBTYPE_CONTROL)
		.value("ACTIONSUBTYPE_AUTOMATE", ACTIONSUBTYPE_AUTOMATE)
		.value("ACTIONSUBTYPE_MISSION", ACTIONSUBTYPE_MISSION)

		.value("NUM_ACTIONSUBTYPES", NUM_ACTIONSUBTYPES)
		;

	python::enum_<GameMessageTypes>("GameMessageTypes")
		.value("GAMEMESSAGE_NETWORK_READY", GAMEMESSAGE_NETWORK_READY)
		.value("GAMEMESSAGE_SAVE_GAME_FLAG", GAMEMESSAGE_SAVE_GAME_FLAG)
		.value("GAMEMESSAGE_SAVE_FLAG_ACK", GAMEMESSAGE_SAVE_FLAG_ACK)
		.value("GAMEMESSAGE_VERIFY_VERSION", GAMEMESSAGE_VERIFY_VERSION)
		.value("GAMEMESSAGE_VERSION_NACK", GAMEMESSAGE_VERSION_NACK)
		.value("GAMEMESSAGE_VERSION_WARNING", GAMEMESSAGE_VERSION_WARNING)
		.value("GAMEMESSAGE_GAME_TYPE", GAMEMESSAGE_GAME_TYPE)
		.value("GAMEMESSAGE_ID_ASSIGNMENT", GAMEMESSAGE_ID_ASSIGNMENT)
		.value("GAMEMESSAGE_FILE_INFO", GAMEMESSAGE_FILE_INFO)
		.value("GAMEMESSAGE_PICK_YOUR_CIV", GAMEMESSAGE_PICK_YOUR_CIV)
		.value("GAMEMESSAGE_CIV_CHOICE", GAMEMESSAGE_CIV_CHOICE)
		.value("GAMEMESSAGE_CONFIRM_CIV_CLAIM", GAMEMESSAGE_CONFIRM_CIV_CLAIM) 
		.value("GAMEMESSAGE_CLAIM_INFO", GAMEMESSAGE_CLAIM_INFO)
		.value("GAMEMESSAGE_CIV_CHOICE_ACK", GAMEMESSAGE_CIV_CHOICE_ACK)
		.value("GAMEMESSAGE_CIV_CHOICE_NACK", GAMEMESSAGE_CIV_CHOICE_NACK)
		.value("GAMEMESSAGE_CIV_CHOSEN", GAMEMESSAGE_CIV_CHOSEN)
		.value("GAMEMESSAGE_INTERIM_NOTICE", GAMEMESSAGE_INTERIM_NOTICE)
		.value("GAMEMESSAGE_INIT_INFO", GAMEMESSAGE_INIT_INFO)
		.value("GAMEMESSAGE_MAPSCRIPT_CHECK", GAMEMESSAGE_MAPSCRIPT_CHECK)
		.value("GAMEMESSAGE_MAPSCRIPT_ACK", GAMEMESSAGE_MAPSCRIPT_ACK)
		.value("GAMEMESSAGE_LOAD_GAME", GAMEMESSAGE_LOAD_GAME)
		.value("GAMEMESSAGE_PLAYER_ID", GAMEMESSAGE_PLAYER_ID)
		.value("GAMEMESSAGE_SLOT_REASSIGNMENT", GAMEMESSAGE_SLOT_REASSIGNMENT)
		.value("GAMEMESSAGE_PLAYER_INFO", GAMEMESSAGE_PLAYER_INFO)
		.value("GAMEMESSAGE_GAME_INFO", GAMEMESSAGE_GAME_INFO)
		.value("GAMEMESSAGE_REASSIGN_PLAYER", GAMEMESSAGE_REASSIGN_PLAYER)
		.value("GAMEMESSAGE_PITBOSS_INFO", GAMEMESSAGE_PITBOSS_INFO)
		.value("GAMEMESSAGE_LAUNCHING_INFO", GAMEMESSAGE_LAUNCHING_INFO)
		.value("GAMEMESSAGE_INIT_GAME", GAMEMESSAGE_INIT_GAME)
		.value("GAMEMESSAGE_INIT_PLAYERS", GAMEMESSAGE_INIT_PLAYERS)
		.value("GAMEMESSAGE_AUTH_REQUEST", GAMEMESSAGE_AUTH_REQUEST)
		.value("GAMEMESSAGE_AUTH_RESPONSE", GAMEMESSAGE_AUTH_RESPONSE)
		.value("GAMEMESSAGE_SYNCH_START", GAMEMESSAGE_SYNCH_START)
		.value("GAMEMESSAGE_PLAYER_OPTION", GAMEMESSAGE_PLAYER_OPTION)
		.value("GAMEMESSAGE_EXTENDED_GAME", GAMEMESSAGE_EXTENDED_GAME)
		.value("GAMEMESSAGE_AUTO_MOVES", GAMEMESSAGE_AUTO_MOVES)
		.value("GAMEMESSAGE_TURN_COMPLETE", GAMEMESSAGE_TURN_COMPLETE)
		.value("GAMEMESSAGE_JOIN_GROUP", GAMEMESSAGE_JOIN_GROUP)
		.value("GAMEMESSAGE_PUSH_MISSION", GAMEMESSAGE_PUSH_MISSION)
		.value("GAMEMESSAGE_AUTO_MISSION", GAMEMESSAGE_AUTO_MISSION)
		.value("GAMEMESSAGE_DO_COMMAND", GAMEMESSAGE_DO_COMMAND)
		.value("GAMEMESSAGE_PUSH_ORDER", GAMEMESSAGE_PUSH_ORDER)
		.value("GAMEMESSAGE_POP_ORDER", GAMEMESSAGE_POP_ORDER)
		.value("GAMEMESSAGE_DO_TASK", GAMEMESSAGE_DO_TASK)
		.value("GAMEMESSAGE_RESEARCH", GAMEMESSAGE_RESEARCH)
		.value("GAMEMESSAGE_PERCENT_CHANGE", GAMEMESSAGE_PERCENT_CHANGE)
		.value("GAMEMESSAGE_ESPIONAGE_CHANGE", GAMEMESSAGE_ESPIONAGE_CHANGE)
		.value("GAMEMESSAGE_CONVERT", GAMEMESSAGE_CONVERT)
		.value("GAMEMESSAGE_CHAT", GAMEMESSAGE_CHAT)
		.value("GAMEMESSAGE_PING", GAMEMESSAGE_PING)
		.value("GAMEMESSAGE_SIGN", GAMEMESSAGE_SIGN)
		.value("GAMEMESSAGE_LINE_ENTITY", GAMEMESSAGE_LINE_ENTITY)
		.value("GAMEMESSAGE_SIGN_DELETE", GAMEMESSAGE_SIGN_DELETE)
		.value("GAMEMESSAGE_LINE_ENTITY_DELETE", GAMEMESSAGE_LINE_ENTITY_DELETE)
		.value("GAMEMESSAGE_LINE_GROUP_DELETE", GAMEMESSAGE_LINE_GROUP_DELETE)
		.value("GAMEMESSAGE_PAUSE", GAMEMESSAGE_PAUSE)
		.value("GAMEMESSAGE_MP_KICK", GAMEMESSAGE_MP_KICK)
		.value("GAMEMESSAGE_MP_RETIRE", GAMEMESSAGE_MP_RETIRE)
		.value("GAMEMESSAGE_CLOSE_CONNECTION", GAMEMESSAGE_CLOSE_CONNECTION)
		.value("GAMEMESSAGE_NEVER_JOINED", GAMEMESSAGE_NEVER_JOINED)
		.value("GAMEMESSAGE_MP_DROP_INIT", GAMEMESSAGE_MP_DROP_INIT)
		.value("GAMEMESSAGE_MP_DROP_VOTE", GAMEMESSAGE_MP_DROP_VOTE)
		.value("GAMEMESSAGE_MP_DROP_UPDATE", GAMEMESSAGE_MP_DROP_UPDATE)
		.value("GAMEMESSAGE_MP_DROP_RESULT", GAMEMESSAGE_MP_DROP_RESULT)
		.value("GAMEMESSAGE_MP_DROP_SAVE", GAMEMESSAGE_MP_DROP_SAVE)
		.value("GAMEMESSAGE_TOGGLE_TRADE", GAMEMESSAGE_TOGGLE_TRADE)
		.value("GAMEMESSAGE_IMPLEMENT_OFFER", GAMEMESSAGE_IMPLEMENT_OFFER)
		.value("GAMEMESSAGE_CHANGE_WAR", GAMEMESSAGE_CHANGE_WAR)
		.value("GAMEMESSAGE_CHANGE_VASSAL", GAMEMESSAGE_CHANGE_VASSAL)
		.value("GAMEMESSAGE_CHOOSE_ELECTION", GAMEMESSAGE_CHOOSE_ELECTION)
		.value("GAMEMESSAGE_DIPLO_VOTE", GAMEMESSAGE_DIPLO_VOTE)
		.value("GAMEMESSAGE_APPLY_EVENT", GAMEMESSAGE_APPLY_EVENT)
		.value("GAMEMESSAGE_CONTACT_CIV", GAMEMESSAGE_CONTACT_CIV)
		.value("GAMEMESSAGE_DIPLO_CHAT", GAMEMESSAGE_DIPLO_CHAT)
		.value("GAMEMESSAGE_SEND_OFFER", GAMEMESSAGE_SEND_OFFER)
		.value("GAMEMESSAGE_DIPLO_EVENT", GAMEMESSAGE_DIPLO_EVENT)
		.value("GAMEMESSAGE_RENEGOTIATE", GAMEMESSAGE_RENEGOTIATE)
		.value("GAMEMESSAGE_RENEGOTIATE_ITEM", GAMEMESSAGE_RENEGOTIATE_ITEM)
		.value("GAMEMESSAGE_EXIT_TRADE", GAMEMESSAGE_EXIT_TRADE)
		.value("GAMEMESSAGE_KILL_DEAL", GAMEMESSAGE_KILL_DEAL)
		.value("GAMEMESSAGE_SAVE_GAME", GAMEMESSAGE_SAVE_GAME)
		.value("GAMEMESSAGE_UPDATE_CIVICS", GAMEMESSAGE_UPDATE_CIVICS)
		.value("GAMEMESSAGE_CLEAR_TABLE", GAMEMESSAGE_CLEAR_TABLE)
		.value("GAMEMESSAGE_POPUP_PROCESSED", GAMEMESSAGE_POPUP_PROCESSED)
		.value("GAMEMESSAGE_DIPLOMACY_PROCESSED", GAMEMESSAGE_DIPLOMACY_PROCESSED)
		.value("GAMEMESSAGE_HOT_JOIN_NOTICE", GAMEMESSAGE_HOT_JOIN_NOTICE)
		.value("GAMEMESSAGE_HOT_DROP_NOTICE", GAMEMESSAGE_HOT_DROP_NOTICE)
		.value("GAMEMESSAGE_DIPLOMACY", GAMEMESSAGE_DIPLOMACY)
		.value("GAMEMESSAGE_POPUP", GAMEMESSAGE_POPUP)
		.value("GAMEMESSAGE_EVENT_TRIGGERED", GAMEMESSAGE_EVENT_TRIGGERED)
		.value("GAMEMESSAGE_EMPIRE_SPLIT", GAMEMESSAGE_EMPIRE_SPLIT)
		.value("GAMEMESSAGE_LAUNCH_SPACESHIP", GAMEMESSAGE_LAUNCH_SPACESHIP)
		.value("GAMEMESSAGE_ADVANCED_START_ACTION", GAMEMESSAGE_ADVANCED_START_ACTION)
		.value("GAMEMESSAGE_FOUND_RELIGION", GAMEMESSAGE_FOUND_RELIGION)
		.value("GAMEMESSAGE_MOD_NET_MESSAGE", GAMEMESSAGE_MOD_NET_MESSAGE)
		;

	python::enum_<PopupControlLayout>("PopupControlLayout")
		.value("POPUP_LAYOUT_LEFT", POPUP_LAYOUT_LEFT)
		.value("POPUP_LAYOUT_CENTER", POPUP_LAYOUT_CENTER)
		.value("POPUP_LAYOUT_RIGHT", POPUP_LAYOUT_RIGHT)
		.value("POPUP_LAYOUT_STRETCH", POPUP_LAYOUT_STRETCH)
		.value("POPUP_LAYOUT_NUMLAYOUTS", POPUP_LAYOUT_NUMLAYOUTS)
		;

	python::enum_<JustificationTypes>("JustificationTypes")
		.value("DLL_FONT_LEFT_JUSTIFY", DLL_FONT_LEFT_JUSTIFY)
		.value("DLL_FONT_RIGHT_JUSTIFY", DLL_FONT_RIGHT_JUSTIFY)
		.value("DLL_FONT_CENTER_JUSTIFY", DLL_FONT_CENTER_JUSTIFY)
		.value("DLL_FONT_CENTER_VERTICALLY", DLL_FONT_CENTER_VERTICALLY)
		.value("DLL_FONT_ADDITIVE", DLL_FONT_ADDITIVE)
		;

	python::enum_<ToolTipAlignTypes>("ToolTipAlignTypes")
		.value("TOOLTIP_TOP_LEFT", TOOLTIP_TOP_LEFT)
		.value("TOOLTIP_TOP_INLEFT", TOOLTIP_TOP_INLEFT)
		.value("TOOLTIP_TOP_CENTER", TOOLTIP_TOP_CENTER)
		.value("TOOLTIP_TOP_INRIGHT", TOOLTIP_TOP_INRIGHT)
		.value("TOOLTIP_TOP_RIGHT", TOOLTIP_TOP_RIGHT)

		.value("TOOLTIP_INTOP_RIGHT", TOOLTIP_INTOP_RIGHT)
		.value("TOOLTIP_CENTER_RIGHT", TOOLTIP_CENTER_RIGHT)
		.value("TOOLTIP_INBOTTOM_RIGHT", TOOLTIP_INBOTTOM_RIGHT)

		.value("TOOLTIP_BOTTOM_RIGHT", TOOLTIP_BOTTOM_RIGHT)
		.value("TOOLTIP_BOTTOM_INRIGHT", TOOLTIP_BOTTOM_INRIGHT)
		.value("TOOLTIP_BOTTOM_CENTER", TOOLTIP_BOTTOM_CENTER)
		.value("TOOLTIP_BOTTOM_INLEFT", TOOLTIP_BOTTOM_INLEFT)
		.value("TOOLTIP_BOTTOM_LEFT", TOOLTIP_BOTTOM_LEFT)

		.value("TOOLTIP_INBOTTOM_LEFT", TOOLTIP_INBOTTOM_LEFT)
		.value("TOOLTIP_CENTER_LEFT", TOOLTIP_CENTER_LEFT)
		.value("TOOLTIP_INTOP_LEFT", TOOLTIP_INTOP_LEFT)
		;

	python::enum_<ActivationTypes>("ActivationTypes")
		.value("ACTIVATE_NORMAL", ACTIVATE_NORMAL)
		.value("ACTIVATE_CHILDFOCUS", ACTIVATE_CHILDFOCUS)
		.value("ACTIVATE_MIMICPARENT", ACTIVATE_MIMICPARENT)
		.value("ACTIVATE_MIMICPARENTFOCUS", ACTIVATE_MIMICPARENTFOCUS)
		;

	python::enum_<HitTestTypes>("HitTestTypes")
		.value("HITTEST_DEFAULT", HITTEST_DEFAULT)
		.value("HITTEST_NOHIT", HITTEST_NOHIT)
		.value("HITTEST_SOLID", HITTEST_SOLID)
		.value("HITTEST_ON", HITTEST_ON)
		.value("HITTEST_CHILDREN", HITTEST_CHILDREN)
		;

	python::enum_<GraphicLevelTypes>("GraphicLevelTypes")
		.value("GRAPHICLEVEL_HIGH", GRAPHICLEVEL_HIGH)
		.value("GRAPHICLEVEL_MEDIUM", GRAPHICLEVEL_MEDIUM)
		.value("GRAPHICLEVEL_LOW", GRAPHICLEVEL_LOW)
		.value("GRAPHICLEVEL_CURRENT", GRAPHICLEVEL_CURRENT)
		.value("NUM_GRAPHICLEVELS", NUM_GRAPHICLEVELS)
		;

	python::enum_<EventTypes>("EventTypes")
		.value("NO_EVENT", NO_EVENT)
		;

	python::enum_<EventTriggerTypes>("EventTriggerTypes")
		.value("NO_EVENTTRIGGER", NO_EVENTTRIGGER)
		;

	python::enum_<EspionageMissionTypes>("EspionageMissionTypes")
		.value("NO_ESPIONAGEMISSION", NO_ESPIONAGEMISSION)
		;

	python::enum_<AdvancedStartActionTypes>("AdvancedStartActionTypes")
		.value("NO_ADVANCEDSTARTACTION", NO_ADVANCEDSTARTACTION)

		.value("ADVANCEDSTARTACTION_EXIT", ADVANCEDSTARTACTION_EXIT)
		.value("ADVANCEDSTARTACTION_UNIT", ADVANCEDSTARTACTION_UNIT)
		.value("ADVANCEDSTARTACTION_CITY", ADVANCEDSTARTACTION_CITY)
		.value("ADVANCEDSTARTACTION_POP", ADVANCEDSTARTACTION_POP)
		.value("ADVANCEDSTARTACTION_CULTURE", ADVANCEDSTARTACTION_CULTURE)
		.value("ADVANCEDSTARTACTION_BUILDING", ADVANCEDSTARTACTION_BUILDING)
		.value("ADVANCEDSTARTACTION_IMPROVEMENT", ADVANCEDSTARTACTION_IMPROVEMENT)
		.value("ADVANCEDSTARTACTION_ROUTE", ADVANCEDSTARTACTION_ROUTE)
		.value("ADVANCEDSTARTACTION_TECH", ADVANCEDSTARTACTION_TECH)
		.value("ADVANCEDSTARTACTION_VISIBILITY", ADVANCEDSTARTACTION_VISIBILITY)
		.value("ADVANCEDSTARTACTION_AUTOMATE", ADVANCEDSTARTACTION_AUTOMATE)
		;
}
